/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

import QtQuick
import QtQuick.Controls
import QtQuick.Controls.Basic

import "../../components"

CheckBox {
  id: control

  property string sourceIcon: ""
  property bool small: false

  height: (control.small ? 50 : 80) * __dp

  indicator: Rectangle {
    id: iconBgRectangle
    width: (control.small ? 24 : 40) * __dp
    height: (control.small ? 24 : 40) * __dp
    x: 20 * __dp
    y: control.height / 2 - height / 2
    radius: width / 2
    color: control.checked ? __style.polarColor : __style.lightGreenColor

    MMIcon {
      id: icon
      size: control.small ? __style.icon16 : __style.icon24
      anchors.centerIn: parent
      source: control.sourceIcon
      color: __style.forestColor
    }
  }

  contentItem: Text {
    text: control.text
    font: __style.t3
    color: control.checked ? __style.polarColor : __style.nightColor
    elide: Text.ElideRight
    verticalAlignment: Text.AlignVCenter
    leftPadding: control.indicator.width + 30 * __dp
    rightPadding: 20 * __dp
  }

  background: Rectangle {
    radius: __style.radius12
    color: control.checked ? __style.forestColor: __style.polarColor
  }
}
