/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.hardware.camera2.CaptureResult;
import android.media.ExifInterface;
import android.os.Build;
import android.util.Log;
import java.io.IOException;

public class QtExifDataHandler {
    private int mFlashFired = 0;
    private long mExposureTime = 0L;
    private float mFocalLength = 0.0f;
    private static String mModel = Build.MANUFACTURER + " " + Build.MODEL;

    public QtExifDataHandler(CaptureResult captureResult) {
        Long l;
        Integer n = (Integer)captureResult.get(CaptureResult.FLASH_STATE);
        if (n != null && n == 3) {
            this.mFlashFired = 1;
        }
        if ((l = (Long)captureResult.get(CaptureResult.SENSOR_EXPOSURE_TIME)) != null) {
            this.mExposureTime = l / 1000000000L;
        }
        this.mFocalLength = ((Float)captureResult.get(CaptureResult.LENS_FOCAL_LENGTH)).floatValue();
    }

    public void save(String string) {
        ExifInterface exifInterface;
        try {
            exifInterface = new ExifInterface(string);
        }
        catch (IOException iOException) {
            Log.e((String)"QtExifDataHandler", (String)("Cannot open file: " + string + "\n" + iOException));
            return;
        }
        exifInterface.setAttribute("Flash", String.valueOf(this.mFlashFired));
        exifInterface.setAttribute("ExposureTime", String.valueOf(this.mExposureTime));
        exifInterface.setAttribute("FocalLength", String.valueOf(this.mFocalLength));
        exifInterface.setAttribute("Model", mModel);
        try {
            exifInterface.saveAttributes();
        }
        catch (IOException iOException) {
            Log.e((String)"QtExifDataHandler", (String)("Cannot save file: " + string + "\n" + iOException));
        }
    }
}

