/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.Context;
import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Range;
import android.util.Size;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;

public class QtVideoDeviceManager {
    CameraManager mCameraManager;
    Map<String, CameraCharacteristics> cache;

    public QtVideoDeviceManager(Context context) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.cache = new WeakHashMap<String, CameraCharacteristics>();
    }

    public CameraCharacteristics getCameraCharacteristics(String string) {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(string);
            this.cache.put(string, cameraCharacteristics);
            return cameraCharacteristics;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static boolean isSoftwareCodec(String string) {
        return (string = string.toLowerCase()).startsWith("omx.google.") || string.startsWith("c2.android.") || !string.startsWith("omx.") && !string.startsWith("c2.");
    }

    private static String[] getHWVideoCodecs(CODEC cODEC) {
        MediaCodecList mediaCodecList = new MediaCodecList(0);
        MediaCodecInfo[] mediaCodecInfoArray = mediaCodecList.getCodecInfos();
        HashSet<String> hashSet = new HashSet<String>();
        for (MediaCodecInfo mediaCodecInfo : mediaCodecInfoArray) {
            String[] stringArray;
            CODEC cODEC2;
            CODEC cODEC3 = cODEC2 = mediaCodecInfo.isEncoder() ? CODEC.ENCODER : CODEC.DECODER;
            if (cODEC2 != cODEC || QtVideoDeviceManager.isSoftwareCodec(mediaCodecInfo.getName())) continue;
            for (String string : stringArray = mediaCodecInfo.getSupportedTypes()) {
                if (!string.startsWith("video/")) continue;
                hashSet.add(string.substring(6));
            }
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static String[] getHWVideoDecoders() {
        return QtVideoDeviceManager.getHWVideoCodecs(CODEC.DECODER);
    }

    public static String[] getHWVideoEncoders() {
        return QtVideoDeviceManager.getHWVideoCodecs(CODEC.ENCODER);
    }

    public String[] getCameraIdList() {
        try {
            return this.mCameraManager.getCameraIdList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public int getSensorOrientation(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return 0;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    public int getLensFacing(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return 0;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
    }

    public String[] getFpsRange(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        String[] stringArray = new String[rangeArray.length];
        for (int i = 0; i < rangeArray.length; ++i) {
            stringArray[i] = rangeArray[i].toString();
        }
        return stringArray;
    }

    public float getMaxZoom(String string) {
        float f = 1.0f;
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics != null) {
            f = ((Float)cameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
        }
        return f;
    }

    public Rect getActiveArraySize(String string) {
        Rect rect = new Rect();
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics != null) {
            rect = (Rect)cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
        }
        return rect;
    }

    public String[] getStreamConfigurationsSizes(String string, int n) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] sizeArray = streamConfigurationMap.getOutputSizes(n);
        if (sizeArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[sizeArray.length];
        for (int i = 0; i < sizeArray.length; ++i) {
            stringArray[i] = sizeArray[i].toString();
        }
        return stringArray;
    }

    public int stringToControlAEMode(String string) {
        switch (string) {
            case "off": {
                return 1;
            }
            case "auto": {
                return 2;
            }
            case "on": {
                return 3;
            }
            case "redeye": {
                return 4;
            }
            case "external": {
                return 5;
            }
        }
        return -1;
    }

    public String controlAEModeToString(int n) {
        switch (n) {
            case 1: {
                return "off";
            }
            case 2: {
                return "auto";
            }
            case 3: {
                return "on";
            }
            case 4: {
                return "redeye";
            }
            case 5: {
                return "external";
            }
        }
        return "unknown";
    }

    public int[] getSupportedAfModes(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new int[0];
        }
        return (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES);
    }

    public String[] getSupportedFlashModes(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        int[] nArray = (int[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(this.controlAEModeToString(nArray[i]));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    public boolean isTorchModeSupported(String string) {
        boolean bl = false;
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics != null) {
            bl = (Boolean)cameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
        }
        return bl;
    }

    private static enum CODEC {
        DECODER,
        ENCODER;

    }
}

