/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.ClipboardManager;
import android.text.Html;
import android.text.Spanned;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import java.util.ArrayList;
import org.qtproject.qt.android.ButtonStruct;
import org.qtproject.qt.android.QtNativeDialogHelper;

public class QtMessageDialogHelper {
    private Activity m_activity;
    private int m_standardIcon = 0;
    private Spanned m_title;
    private Spanned m_text;
    private Spanned m_informativeText;
    private Spanned m_detailedText;
    private ArrayList<ButtonStruct> m_buttonsList;
    private AlertDialog m_dialog;
    private long m_handler = 0L;
    private Resources.Theme m_theme;

    public QtMessageDialogHelper(Activity activity) {
        this.m_activity = activity;
    }

    public void setStandardIcon(int n) {
        this.m_standardIcon = n;
    }

    private Drawable getIconDrawable() {
        if (this.m_standardIcon == 0) {
            return null;
        }
        try {
            TypedValue typedValue = new TypedValue();
            this.m_theme.resolveAttribute(16843605, typedValue, true);
            return this.m_activity.getResources().getDrawable(typedValue.resourceId, this.m_activity.getTheme());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            switch (this.m_standardIcon) {
                case 1: {
                    try {
                        return this.m_activity.getResources().getDrawable(17301659, this.m_activity.getTheme());
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                        break;
                    }
                }
                case 2: 
                case 3: {
                    try {
                        return this.m_activity.getResources().getDrawable(17301543, this.m_activity.getTheme());
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                        break;
                    }
                }
                case 4: {
                    try {
                        return this.m_activity.getResources().getDrawable(17301568, this.m_activity.getTheme());
                    }
                    catch (Exception exception4) {
                        exception4.printStackTrace();
                    }
                }
            }
            return null;
        }
    }

    public void setTile(String string2) {
        this.m_title = Html.fromHtml((String)string2);
    }

    public void setText(String string2) {
        this.m_text = Html.fromHtml((String)string2);
    }

    public void setInformativeText(String string2) {
        this.m_informativeText = Html.fromHtml((String)string2);
    }

    public void setDetailedText(String string2) {
        this.m_detailedText = Html.fromHtml((String)string2);
    }

    public void addButton(int n, String string2) {
        if (this.m_buttonsList == null) {
            this.m_buttonsList = new ArrayList();
        }
        this.m_buttonsList.add(new ButtonStruct(this, n, string2));
    }

    private Drawable getStyledDrawable(String string2) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        int[] nArray = new int[]{Class.forName("android.R$attr").getDeclaredField(string2).getInt(null)};
        TypedArray typedArray = this.m_theme.obtainStyledAttributes(nArray);
        Drawable drawable2 = typedArray.getDrawable(0);
        typedArray.recycle();
        return drawable2;
    }

    public void show(long l) {
        this.m_handler = l;
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                RelativeLayout.LayoutParams layoutParams;
                TextView textView;
                if (QtMessageDialogHelper.this.m_dialog != null && QtMessageDialogHelper.this.m_dialog.isShowing()) {
                    QtMessageDialogHelper.this.m_dialog.dismiss();
                }
                QtMessageDialogHelper.this.m_dialog = new AlertDialog.Builder((Context)QtMessageDialogHelper.this.m_activity).create();
                QtMessageDialogHelper.this.m_theme = QtMessageDialogHelper.this.m_dialog.getWindow().getContext().getTheme();
                if (QtMessageDialogHelper.this.m_title != null) {
                    QtMessageDialogHelper.this.m_dialog.setTitle((CharSequence)QtMessageDialogHelper.this.m_title);
                }
                QtMessageDialogHelper.this.m_dialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialogInterface) {
                        QtNativeDialogHelper.dialogResult(QtMessageDialogHelper.this.handler(), -1);
                    }
                });
                QtMessageDialogHelper.this.m_dialog.setCancelable(QtMessageDialogHelper.this.m_buttonsList == null);
                QtMessageDialogHelper.this.m_dialog.setCanceledOnTouchOutside(QtMessageDialogHelper.this.m_buttonsList == null);
                QtMessageDialogHelper.this.m_dialog.setIcon(QtMessageDialogHelper.this.getIconDrawable());
                ScrollView scrollView = new ScrollView((Context)QtMessageDialogHelper.this.m_activity);
                RelativeLayout relativeLayout = new RelativeLayout((Context)QtMessageDialogHelper.this.m_activity);
                int n = 1;
                TextView textView2 = null;
                View.OnLongClickListener onLongClickListener = new View.OnLongClickListener(){

                    public boolean onLongClick(View view) {
                        TextView textView = (TextView)view;
                        if (textView != null) {
                            ClipboardManager clipboardManager = (ClipboardManager)QtMessageDialogHelper.this.m_activity.getSystemService("clipboard");
                            clipboardManager.setText(textView.getText());
                        }
                        return true;
                    }
                };
                if (QtMessageDialogHelper.this.m_text != null) {
                    textView = new TextView((Context)QtMessageDialogHelper.this.m_activity);
                    textView.setId(n++);
                    textView.setOnLongClickListener(onLongClickListener);
                    textView.setLongClickable(true);
                    textView.setText((CharSequence)QtMessageDialogHelper.this.m_text);
                    textView.setTextAppearance((Context)QtMessageDialogHelper.this.m_activity, 16973892);
                    layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                    layoutParams.setMargins(16, 8, 16, 8);
                    layoutParams.addRule(10);
                    relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
                    textView2 = textView;
                }
                if (QtMessageDialogHelper.this.m_informativeText != null) {
                    textView = new TextView((Context)QtMessageDialogHelper.this.m_activity);
                    textView.setId(n++);
                    textView.setOnLongClickListener(onLongClickListener);
                    textView.setLongClickable(true);
                    textView.setText((CharSequence)QtMessageDialogHelper.this.m_informativeText);
                    textView.setTextAppearance((Context)QtMessageDialogHelper.this.m_activity, 16973892);
                    layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                    layoutParams.setMargins(16, 8, 16, 8);
                    if (textView2 != null) {
                        layoutParams.addRule(3, textView2.getId());
                    } else {
                        layoutParams.addRule(10);
                    }
                    relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
                    textView2 = textView;
                }
                if (QtMessageDialogHelper.this.m_detailedText != null) {
                    textView = new TextView((Context)QtMessageDialogHelper.this.m_activity);
                    textView.setId(n++);
                    textView.setOnLongClickListener(onLongClickListener);
                    textView.setLongClickable(true);
                    textView.setText((CharSequence)QtMessageDialogHelper.this.m_detailedText);
                    textView.setTextAppearance((Context)QtMessageDialogHelper.this.m_activity, 16973894);
                    layoutParams = new RelativeLayout.LayoutParams(-1, -2);
                    layoutParams.setMargins(16, 8, 16, 8);
                    if (textView2 != null) {
                        layoutParams.addRule(3, textView2.getId());
                    } else {
                        layoutParams.addRule(10);
                    }
                    relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)layoutParams);
                    textView2 = textView;
                }
                if (QtMessageDialogHelper.this.m_buttonsList != null) {
                    View view;
                    textView = new LinearLayout((Context)QtMessageDialogHelper.this.m_activity);
                    textView.setOrientation(0);
                    textView.setId(n++);
                    boolean bl = true;
                    for (ButtonStruct buttonStruct : QtMessageDialogHelper.this.m_buttonsList) {
                        LinearLayout.LayoutParams layoutParams2;
                        Button button;
                        try {
                            button = new Button((Context)QtMessageDialogHelper.this.m_activity, null, Class.forName("android.R$attr").getDeclaredField("borderlessButtonStyle").getInt(null));
                        }
                        catch (Exception exception) {
                            button = new Button((Context)QtMessageDialogHelper.this.m_activity);
                            exception.printStackTrace();
                        }
                        button.setText((CharSequence)buttonStruct.m_text);
                        button.setOnClickListener((View.OnClickListener)buttonStruct);
                        if (!bl) {
                            layoutParams2 = null;
                            View view2 = new View((Context)QtMessageDialogHelper.this.m_activity);
                            try {
                                layoutParams2 = new LinearLayout.LayoutParams(1, -1);
                                view2.setBackgroundDrawable(QtMessageDialogHelper.this.getStyledDrawable("dividerVertical"));
                                textView.addView(view2, (ViewGroup.LayoutParams)layoutParams2);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                        layoutParams2 = null;
                        layoutParams2 = new LinearLayout.LayoutParams(-1, -2, 1.0f);
                        textView.addView((View)button, (ViewGroup.LayoutParams)layoutParams2);
                        bl = false;
                    }
                    try {
                        ButtonStruct buttonStruct;
                        view = new View((Context)QtMessageDialogHelper.this.m_activity);
                        view.setId(n++);
                        view.setBackgroundDrawable(QtMessageDialogHelper.this.getStyledDrawable("dividerHorizontal"));
                        buttonStruct = new RelativeLayout.LayoutParams(-1, 1);
                        buttonStruct.setMargins(0, 10, 0, 0);
                        if (textView2 != null) {
                            buttonStruct.addRule(3, textView2.getId());
                        } else {
                            buttonStruct.addRule(10);
                        }
                        relativeLayout.addView(view, (ViewGroup.LayoutParams)buttonStruct);
                        textView2 = view;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    view = new RelativeLayout.LayoutParams(-1, -2);
                    if (textView2 != null) {
                        view.addRule(3, textView2.getId());
                    } else {
                        view.addRule(10);
                    }
                    view.setMargins(2, 0, 2, 0);
                    relativeLayout.addView((View)textView, (ViewGroup.LayoutParams)view);
                }
                scrollView.addView((View)relativeLayout);
                QtMessageDialogHelper.this.m_dialog.setView((View)scrollView);
                QtMessageDialogHelper.this.m_dialog.show();
            }
        });
    }

    public void hide() {
        this.m_activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (QtMessageDialogHelper.this.m_dialog != null && QtMessageDialogHelper.this.m_dialog.isShowing()) {
                    QtMessageDialogHelper.this.m_dialog.dismiss();
                }
                QtMessageDialogHelper.this.reset();
            }
        });
    }

    public long handler() {
        return this.m_handler;
    }

    public void reset() {
        this.m_standardIcon = 0;
        this.m_title = null;
        this.m_text = null;
        this.m_informativeText = null;
        this.m_detailedText = null;
        this.m_buttonsList = null;
        this.m_dialog = null;
        this.m_handler = 0L;
    }
}

