/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ConditionalBasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.cfg.EntryBlock;
import com.android.jack.cfg.SwitchBasicBlock;
import com.android.jack.coverage.CodeCoverageFeature;
import com.android.jack.coverage.CodeCoverageMarker;
import com.android.jack.coverage.ProbeDescription;
import com.android.jack.coverage.ProbeMarker;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JIfStatement;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JVisitable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.transformations.EmptyClinit;
import com.android.sched.item.Description;
import com.android.sched.marker.Marker;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Filter;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.schedulable.Transform;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Code coverage analyzer")
@Support(value={CodeCoverageFeature.class})
@Constraint(need={CodeCoverageMarker.Initialized.class, ControlFlowGraph.class}, no={EmptyClinit.class})
@Transform(add={CodeCoverageMarker.Analyzed.class, ProbeMarker.class}, modify={CodeCoverageMarker.class})
@Filter(value={TypeWithoutPrebuiltFilter.class})
public class CodeCoverageAnalyzer
implements RunnableSchedulable<JMethod> {
    public void run(@Nonnull JMethod m) {
        if (m.isNative() || m.isAbstract()) {
            return;
        }
        JDefinedClassOrInterface declaringClass = m.getEnclosingType();
        CodeCoverageMarker coverageMarker = (CodeCoverageMarker)declaringClass.getMarker(CodeCoverageMarker.class);
        if (coverageMarker == null) {
            return;
        }
        ControlFlowGraph controlFlowGraph = (ControlFlowGraph)m.getMarker(ControlFlowGraph.class);
        assert (controlFlowGraph != null);
        CodeCoverageAnalyzer.analyzeCFG(m, controlFlowGraph, coverageMarker);
    }

    private static void analyzeCFG(@Nonnull JMethod method, @Nonnull ControlFlowGraph controlFlowGraph, @Nonnull CodeCoverageMarker coverageMarker) {
        ArrayDeque<BasicBlock> workQueue = new ArrayDeque<BasicBlock>();
        HashSet<BasicBlock> visitedBlocks = new HashSet<BasicBlock>();
        EntryBlock entryBlock = controlFlowGraph.getEntryNode();
        BasicBlock exitBlock = (BasicBlock)controlFlowGraph.getExitNode();
        workQueue.addAll(entryBlock.getSuccessors());
        assert (!workQueue.isEmpty());
        ProbeDescription currentProbe = coverageMarker.createProbe(method);
        while (!workQueue.isEmpty()) {
            BasicBlock bb = (BasicBlock)workQueue.removeFirst();
            assert (bb != entryBlock);
            assert (bb != exitBlock);
            assert (!visitedBlocks.contains(bb));
            assert (!bb.containsMarker(ProbeMarker.class));
            assert (currentProbe != null);
            visitedBlocks.add(bb);
            for (BasicBlock succ : bb.getSuccessors()) {
                if (succ == exitBlock || visitedBlocks.contains(succ) || workQueue.contains(succ)) continue;
                workQueue.addFirst(succ);
            }
            for (JStatement st : bb.getStatements()) {
                ProbeUpdater visitor = new ProbeUpdater(currentProbe);
                visitor.accept((JVisitable)st);
            }
            for (BasicBlock pred : bb.getPredecessors()) {
                if (!(pred instanceof ConditionalBasicBlock) && !(pred instanceof SwitchBasicBlock)) continue;
                List predStatements = pred.getStatements();
                JStatement branchStatement = (JStatement)predStatements.get(predStatements.size() - 1);
                assert (branchStatement instanceof JIfStatement || branchStatement instanceof JSwitchStatement);
                SourceInfo branchSourceInfo = branchStatement.getSourceInfo();
                currentProbe.incrementLine(branchSourceInfo.getStartLine(), 1, true);
            }
            if (!CodeCoverageAnalyzer.isLastBlockForProbe(bb, exitBlock)) continue;
            bb.addMarker((Marker)new ProbeMarker(currentProbe));
            if (workQueue.isEmpty()) continue;
            currentProbe = coverageMarker.createProbe(method);
        }
        assert (visitedBlocks.size() == controlFlowGraph.getNodes().size());
    }

    private static boolean isLastBlockForProbe(@Nonnull BasicBlock bb, @Nonnull BasicBlock exitBlock) {
        assert (bb != exitBlock);
        List successors = bb.getSuccessors();
        int successorsCount = successors.size();
        if (successorsCount > 1) {
            return true;
        }
        assert (successorsCount == 1);
        BasicBlock succ = (BasicBlock)successors.get(0);
        if (succ.getPredecessors().size() > 1) {
            return true;
        }
        return succ == exitBlock;
    }

    private static class ProbeUpdater
    extends JVisitor {
        @Nonnull
        private final ProbeDescription probe;

        public ProbeUpdater(@Nonnull ProbeDescription probe) {
            this.probe = probe;
        }

        public void endVisit(@Nonnull JExpression x) {
            this.updateProbe(x.getSourceInfo());
        }

        public boolean visit(@Nonnull JIfStatement x) {
            this.accept((JVisitable)x.getIfExpr());
            return false;
        }

        public boolean visit(@Nonnull JSwitchStatement x) {
            this.accept((JVisitable)x.getExpr());
            return false;
        }

        public boolean visit(@Nonnull JStatement x) {
            this.updateProbe(x.getSourceInfo());
            return false;
        }

        private void updateProbe(@Nonnull SourceInfo sourceInfo) {
            int line = sourceInfo != SourceInfo.UNKNOWN ? sourceInfo.getStartLine() : -1;
            this.probe.incrementLine(line, 1, false);
        }
    }
}

