/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.coverage.CodeCoverageFeature;
import com.android.jack.coverage.CodeCoverageMarker;
import com.android.jack.coverage.CodeCoverageMetadataFile;
import com.android.jack.coverage.ProbeDescription;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitable;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.formatter.BinarySignatureFormatter;
import com.android.jack.ir.formatter.TypeAndMethodFormatter;
import com.android.jack.ir.formatter.TypeFormatter;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.ReportableIOException;
import com.android.jack.reporting.Reporter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Produce;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.SchedIOException;
import com.android.sched.util.file.WriterFile;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.stream.CustomPrintWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

@Description(value="Writes Jacoco metadata file.")
@Constraint(need={CodeCoverageMarker.Complete.class})
@Transform(remove={CodeCoverageMarker.class})
@Produce(value={CodeCoverageMetadataFile.class})
public class CodeCoverageMetadataFileWriter
implements RunnableSchedulable<JSession> {
    @Nonnull
    public static final String VERSION = "1.0";
    @Nonnull
    public static final String JSON_VERSION_ATTRIBUTE = "version";
    @Nonnull
    public static final String JSON_DATA_ATTRIBUTE = "data";
    @Nonnull
    private static final TypeFormatter typeFormatter = BinaryQualifiedNameFormatter.getFormatter();
    @Nonnull
    private static final TypeAndMethodFormatter methodFormatter = BinarySignatureFormatter.getFormatter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(@Nonnull JSession session) {
        WriterFile file = (WriterFile)ThreadConfig.get((PropertyId)CodeCoverageFeature.COVERAGE_METADATA_FILE);
        CustomPrintWriter writer = file.getPrintWriter();
        try {
            this.writeMetadata(session, (PrintWriter)writer);
        }
        finally {
            writer.close();
            try {
                writer.throwPendingException();
            }
            catch (IOException e) {
                session.getReporter().report(Reporter.Severity.FATAL, (Reportable)new ReportableIOException("Coverage metadata", (SchedIOException)new CannotWriteException((HasLocation)file, (Throwable)e)));
                session.abortEventually();
            }
        }
    }

    private void writeMetadata(@Nonnull JSession session, @Nonnull PrintWriter writer) {
        writer.print("{ \"");
        writer.print(JSON_VERSION_ATTRIBUTE);
        writer.print("\":\"");
        writer.print(VERSION);
        writer.print("\", \"");
        writer.print(JSON_DATA_ATTRIBUTE);
        writer.println("\":[");
        Iterator list = session.getTypesToEmit().iterator();
        boolean first = true;
        while (list.hasNext()) {
            JDefinedClassOrInterface c = (JDefinedClassOrInterface)list.next();
            CodeCoverageMarker marker = (CodeCoverageMarker)c.removeMarker(CodeCoverageMarker.class);
            if (marker == null || marker.getProbes().isEmpty()) continue;
            if (first) {
                writer.println("{");
                first = false;
            } else {
                writer.println(",{");
            }
            new Visitor(writer, marker).accept((JVisitable)c);
            writer.print('}');
            if (list.hasNext()) continue;
            writer.println();
        }
        writer.println("]}");
        writer.flush();
    }

    private static class Visitor
    extends JVisitor {
        private static final String ONE_TAB = "  ";
        private static final int ONE_TAB_LENGTH = "  ".length();
        @Nonnull
        private final PrintWriter writer;
        @Nonnull
        private final CodeCoverageMarker marker;
        @Nonnull
        private String currentIndent = "";

        public Visitor(@Nonnull PrintWriter writer, @Nonnull CodeCoverageMarker marker) {
            this.writer = writer;
            this.marker = marker;
        }

        private void indent() {
            this.currentIndent = ONE_TAB + this.currentIndent;
        }

        private void unindent() {
            if (this.currentIndent.length() < ONE_TAB_LENGTH) {
                throw new IllegalStateException("Cannot decrement indentation");
            }
            this.currentIndent = this.currentIndent.substring(ONE_TAB_LENGTH);
        }

        private void println(@Nonnull String str) {
            this.writer.println(this.currentIndent + str);
        }

        private static String getSourceFileNameWithoutPath(@Nonnull JDefinedClassOrInterface x) {
            int pos;
            SourceInfo sourceInfo = x.getSourceInfo();
            String sourceFilename = "";
            if (sourceInfo != SourceInfo.UNKNOWN && (pos = (sourceFilename = sourceInfo.getFileSourceInfo().getFileName()).lastIndexOf(File.separator)) != -1) {
                sourceFilename = sourceFilename.substring(pos + 1);
            }
            return sourceFilename;
        }

        public boolean visit(@Nonnull JDefinedClassOrInterface x) {
            int i;
            String className = typeFormatter.getName((JType)x);
            JClass superClass = x.getSuperClass();
            String superClassName = superClass != null ? typeFormatter.getName((JType)superClass) : "";
            String sourceFilename = Visitor.getSourceFileNameWithoutPath(x);
            List<ProbeDescription> probes = this.marker.getProbes();
            JMethod coverageInitMethod = this.marker.getInitMethod();
            assert (coverageInitMethod != null);
            ArrayList<JMethod> methods = new ArrayList<JMethod>(x.getMethods().size());
            for (JMethod m : x.getMethods()) {
                if (m.isNative() || m.isAbstract() || m == coverageInitMethod) continue;
                methods.add(m);
            }
            long classID = this.marker.getClassId();
            assert (classID != -1L);
            this.indent();
            this.println("\"id\": " + classID + ",");
            this.println("\"name\": \"" + className + "\",");
            this.println("\"superClassName\": \"" + superClassName + "\",");
            this.println("\"sourceFile\": \"" + sourceFilename + "\",");
            this.println("\"interfaces\": [");
            this.indent();
            List interfaces = x.getImplements();
            int e = interfaces.size();
            for (i = 0; i < e; ++i) {
                JInterface inf = (JInterface)interfaces.get(i);
                String commaSuffix = i < e - 1 ? "," : "";
                this.println("\"" + typeFormatter.getName((JType)inf) + "\"" + commaSuffix);
            }
            this.unindent();
            this.println("],");
            this.println("\"methods\": [");
            this.indent();
            e = methods.size();
            for (i = 0; i < e; ++i) {
                JMethod m = (JMethod)methods.get(i);
                String methodSignature = methodFormatter.getName(m);
                int nameEndPos = methodSignature.indexOf(40);
                assert (nameEndPos > 0);
                String methodName = methodSignature.substring(0, nameEndPos);
                String methodDesc = methodSignature.substring(nameEndPos);
                this.println("{");
                this.indent();
                this.println("\"id\": " + i + ",");
                this.println("\"name\": \"" + methodName + "\",");
                this.println("\"desc\": \"" + methodDesc + "\"");
                this.unindent();
                if (i == e - 1) {
                    this.println("}");
                    continue;
                }
                this.println("},");
            }
            this.unindent();
            this.println("],");
            this.println("\"probes\": [");
            this.indent();
            e = probes.size();
            for (i = 0; i < e; ++i) {
                ProbeDescription p = probes.get(i);
                this.println("{");
                this.indent();
                this.println("\"id\": " + probes.get(i).getProbeId() + ",");
                this.println("\"method\": " + methods.indexOf(p.getMethod()) + ",");
                this.println("\"lines\": [");
                this.indent();
                Map<Integer, ProbeDescription.ProbeLineData> linesMap = p.getLineToData();
                Iterator<Map.Entry<Integer, ProbeDescription.ProbeLineData>> keyIterator = linesMap.entrySet().iterator();
                while (keyIterator.hasNext()) {
                    Map.Entry<Integer, ProbeDescription.ProbeLineData> entry = keyIterator.next();
                    int line = entry.getKey();
                    ProbeDescription.ProbeLineData data = entry.getValue();
                    this.println("{");
                    this.indent();
                    this.println("\"line\": " + line + ",");
                    int insnsCount = data.getNodesCount();
                    int branchCount = data.getBranchesCount();
                    this.println("\"insnCount\": " + insnsCount + ",");
                    this.println("\"branchCount\": " + branchCount);
                    this.unindent();
                    if (keyIterator.hasNext()) {
                        this.println("},");
                        continue;
                    }
                    this.println("}");
                }
                this.unindent();
                this.println("]");
                this.unindent();
                if (i == e - 1) {
                    this.println("}");
                    continue;
                }
                this.println("},");
            }
            this.unindent();
            this.println("]");
            this.unindent();
            return true;
        }
    }
}

