/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.coverage;

import com.android.jack.cfg.CfgBuilder;
import com.android.jack.cfg.CfgMarkerRemover;
import com.android.jack.coverage.CodeCoverageAnalyzer;
import com.android.jack.coverage.CodeCoverageFeature;
import com.android.jack.coverage.CodeCoverageMetadataFile;
import com.android.jack.coverage.CodeCoverageMetadataFileWriter;
import com.android.jack.coverage.CodeCoverageSelector;
import com.android.jack.coverage.CodeCoverageTransformer;
import com.android.jack.plugin.v01.SchedAnnotationProcessorBasedPlugin;
import com.android.sched.item.Component;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.scheduler.FeatureSet;
import com.android.sched.scheduler.ProductionSet;
import com.android.sched.scheduler.Scheduler;
import com.android.sched.util.UncomparableVersion;
import com.android.sched.util.Version;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.id.PropertyId;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class CodeCoveragePlugin
extends SchedAnnotationProcessorBasedPlugin {
    public static final String PLUGIN_NAME = "com.android.jack.coverage.CodeCoverage";
    private static final String PLUGIN_FRIENDLY_NAME = "CodeCoverage";
    private static final String PLUGIN_DESCRIPTION = "Code coverage support 'a la' JaCoCo";
    private static final int JACK_COMPATIBLE_VERSION_RELEASE_CODE = 4;
    private static final int JACK_COMPATIBLE_VERSION_SUBRELEASE_CODE = 21;

    @Nonnull
    public String getCanonicalName() {
        return PLUGIN_NAME;
    }

    @Nonnull
    public String getFriendlyName() {
        return PLUGIN_FRIENDLY_NAME;
    }

    @Nonnull
    public String getDescription() {
        return PLUGIN_DESCRIPTION;
    }

    @Nonnull
    public Version getVersion() {
        try {
            return new Version("jack-coverage-plugin", CodeCoveragePlugin.class.getClassLoader());
        }
        catch (IOException e) {
            throw new AssertionError("Failed to find the version of the coverage plugin", e);
        }
    }

    @Nonnull
    public FeatureSet getFeatures(@Nonnull Config config, @Nonnull Scheduler scheduler) {
        FeatureSet set = scheduler.createFeatureSet();
        if (((Boolean)config.get((PropertyId)CodeCoverageFeature.CODE_COVERAGE)).booleanValue()) {
            set.add(CodeCoverageFeature.class);
        }
        return set;
    }

    @Nonnull
    public ProductionSet getProductions(@Nonnull Config config, @Nonnull Scheduler scheduler) {
        ProductionSet set = scheduler.createProductionSet();
        if (((Boolean)config.get((PropertyId)CodeCoverageFeature.CODE_COVERAGE)).booleanValue()) {
            set.add(CodeCoverageMetadataFile.class);
        }
        return set;
    }

    public boolean isCompatibileWithJack(@Nonnull Version jackVersion) {
        try {
            return jackVersion.isNewerOrEqualThan(4, 21);
        }
        catch (UncomparableVersion e) {
            return true;
        }
    }

    @Nonnull
    public List<Class<? extends RunnableSchedulable<? extends Component>>> getSortedRunners() {
        return Arrays.asList(CodeCoverageSelector.class, CodeCoverageAnalyzer.class, CodeCoverageTransformer.class, CodeCoverageMetadataFileWriter.class, CfgMarkerRemover.class, CfgBuilder.class);
    }

    @Nonnull
    public Collection<Class<? extends RunnableSchedulable<? extends Component>>> getCheckerRunners() {
        return Collections.emptyList();
    }
}

