/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import com.android.jack.tools.jacoco.JackMethodCoverage;
import com.android.jack.tools.jacoco.MappingFileLoader;
import com.android.jack.tools.jacoco.NamingUtils;
import com.android.jack.tools.jacoco.ProbeDescription;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.data.ExecutionData;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.CounterImpl;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;

public class JackCoverageAnalyzer {
    @Nonnull
    public static final String CURRENT_VERSION = "1.0";
    @Nonnull
    public static final String JSON_VERSION_ATTRIBUTE = "version";
    @Nonnull
    public static final String JSON_DATA_ATTRIBUTE = "data";
    @Nonnull
    private final ExecutionDataStore executionDataStore;
    @Nonnull
    private final ICoverageVisitor coverageVisitor;
    @CheckForNull
    private final MappingFileLoader mappingFileLoader;
    @CheckForNull
    private MappingFileLoader.ClassMapping currentClassMapping = null;
    @Nonnegative
    private int currentClassProbesCount;

    public JackCoverageAnalyzer(@Nonnull ExecutionDataStore executionDataStore, @Nonnull ICoverageVisitor coverageVisitor, @CheckForNull MappingFileLoader mappingFileLoader) {
        this.executionDataStore = executionDataStore;
        this.coverageVisitor = coverageVisitor;
        this.mappingFileLoader = mappingFileLoader;
    }

    public void analyze(@Nonnull File coverageDescriptionFile) throws IOException {
        FileInputStream inputStream = new FileInputStream(coverageDescriptionFile);
        try {
            this.analyze(inputStream);
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public void analyze(@Nonnull InputStream inputStream) throws IOException {
        JsonReader jsonReader = new JsonReader(new InputStreamReader(inputStream));
        this.readMetadata(jsonReader);
    }

    private void checkVersion(@CheckForNull String version) {
        if (version == null) {
            throw new JsonParseException("Missing 'version' attribute before coverage metadadata");
        }
        String[] parts = version.split(Pattern.quote("."));
        if (parts.length != 2) {
            throw new JsonParseException("Version number format must be x.y");
        }
        if (!version.equals(CURRENT_VERSION)) {
            throw new JsonParseException("Unknown version " + version);
        }
    }

    private void readMetadata(@Nonnull JsonReader jsonReader) throws IOException {
        jsonReader.beginObject();
        String version = null;
        while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if (attributeName.equals(JSON_VERSION_ATTRIBUTE)) {
                version = jsonReader.nextString();
                continue;
            }
            if (attributeName.equals(JSON_DATA_ATTRIBUTE)) {
                this.checkVersion(version);
                this.readClasses(jsonReader);
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
    }

    private void readClasses(@Nonnull JsonReader jsonReader) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            IClassCoverage classCoverage = this.readClass(jsonReader);
            if (classCoverage == null) continue;
            this.coverageVisitor.visitCoverage(classCoverage);
        }
        jsonReader.endArray();
    }

    @CheckForNull
    private IClassCoverage readClass(@Nonnull JsonReader jsonReader) throws IOException {
        boolean noMatch;
        long id = 0L;
        String className = null;
        String sourceFile = null;
        String superClassName = null;
        ArrayList<IMethodCoverage> methods = new ArrayList<IMethodCoverage>();
        ArrayList<ProbeDescription> probes = new ArrayList<ProbeDescription>();
        ArrayList<String> interfaces = new ArrayList<String>();
        this.currentClassProbesCount = 0;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if ("id".equals(attributeName)) {
                id = jsonReader.nextLong();
                continue;
            }
            if ("name".equals(attributeName)) {
                className = jsonReader.nextString();
                if (this.mappingFileLoader == null) continue;
                this.currentClassMapping = this.mappingFileLoader.getClassMapping(className);
                continue;
            }
            if ("sourceFile".equals(attributeName)) {
                sourceFile = jsonReader.nextString();
                continue;
            }
            if ("superClassName".equals(attributeName)) {
                superClassName = jsonReader.nextString();
                continue;
            }
            if ("interfaces".equals(attributeName)) {
                this.readInterfaces(jsonReader, interfaces);
                continue;
            }
            if ("methods".equals(attributeName)) {
                this.readMethods(jsonReader, methods);
                continue;
            }
            if ("probes".equals(attributeName)) {
                this.readProbes(jsonReader, probes, methods);
                continue;
            }
            throw new JsonParseException("Unknown attribute \"" + attributeName + "\"");
        }
        jsonReader.endObject();
        if (id == 0L) {
            throw new JsonParseException("Missing 'id' attribute");
        }
        if (className == null) {
            throw new JsonParseException("Missing 'name' attribute");
        }
        if (superClassName == null) {
            throw new JsonParseException("Missing 'superClassName' attribute");
        }
        ExecutionData executionData = this.executionDataStore.get(id);
        if (executionData != null) {
            noMatch = false;
            executionData.assertCompatibility(id, className, this.currentClassProbesCount);
        } else {
            noMatch = this.executionDataStore.contains(className);
        }
        if (this.currentClassMapping != null) {
            className = this.currentClassMapping.getOriginalClassName();
            assert (className != null);
        } else if (this.mappingFileLoader != null) {
            return null;
        }
        String[] interfacesArray = interfaces.toArray(new String[0]);
        ClassCoverageImpl c = new ClassCoverageImpl(className, id, noMatch, NamingUtils.binaryNameToSignature(className), superClassName, interfacesArray);
        c.setSourceFileName(sourceFile);
        boolean[] executionProbes = executionData != null ? executionData.getProbes() : null;
        for (ProbeDescription probe : probes) {
            int probeIndex = probe.id;
            boolean active = executionProbes != null && executionProbes[probeIndex];
            MethodCoverageImpl methodCoverage = probe.method;
            for (ProbeDescription.Line line : probe.lines) {
                CounterImpl branchCounter;
                CounterImpl instructionCounter;
                if (active) {
                    instructionCounter = CounterImpl.getInstance(0, line.instructionsCount);
                    branchCounter = CounterImpl.getInstance(0, line.branchesCount);
                } else {
                    instructionCounter = CounterImpl.getInstance(line.instructionsCount, 0);
                    branchCounter = CounterImpl.getInstance(line.branchesCount, 0);
                }
                methodCoverage.increment(instructionCounter, branchCounter, line.line);
            }
        }
        for (IMethodCoverage method : methods) {
            c.addMethod(method);
        }
        return c;
    }

    private void readInterfaces(@Nonnull JsonReader jsonReader, @Nonnull List<String> interfaces) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            interfaces.add(jsonReader.nextString());
        }
        jsonReader.endArray();
    }

    private void readProbes(@Nonnull JsonReader jsonReader, @Nonnull List<ProbeDescription> probes, @Nonnull List<? extends IMethodCoverage> methods) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            ProbeDescription probe = this.readProbe(jsonReader, methods);
            if (probe == null) continue;
            probes.add(probe);
        }
        jsonReader.endArray();
    }

    @CheckForNull
    private ProbeDescription readProbe(@Nonnull JsonReader jsonReader, @Nonnull List<? extends IMethodCoverage> methods) throws IOException {
        ++this.currentClassProbesCount;
        ProbeDescription probe = new ProbeDescription();
        jsonReader.beginObject();
        block0: while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if ("id".equals(attributeName)) {
                probe.setId(jsonReader.nextInt());
                continue;
            }
            if ("method".equals(attributeName)) {
                int methodId = jsonReader.nextInt();
                for (IMethodCoverage iMethodCoverage : methods) {
                    if (((JackMethodCoverage)iMethodCoverage).getId() != methodId) continue;
                    probe.setMethod((MethodCoverageImpl)iMethodCoverage);
                    continue block0;
                }
                continue;
            }
            if ("lines".equals(attributeName)) {
                JackCoverageAnalyzer.readLines(jsonReader, probe);
                continue;
            }
            throw new JsonParseException("Unknown attribute \"" + attributeName + "\"");
        }
        jsonReader.endObject();
        if (probe.method != null) {
            return probe;
        }
        return null;
    }

    private static void readLines(@Nonnull JsonReader jsonReader, @Nonnull ProbeDescription probe) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            jsonReader.beginObject();
            int line = -1;
            int instructionsCount = -1;
            int branchesCount = -1;
            while (jsonReader.hasNext()) {
                String attributeName = jsonReader.nextName();
                if ("line".equals(attributeName)) {
                    line = jsonReader.nextInt();
                    continue;
                }
                if ("insnCount".equals(attributeName)) {
                    instructionsCount = jsonReader.nextInt();
                    continue;
                }
                if ("branchCount".equals(attributeName)) {
                    branchesCount = jsonReader.nextInt();
                    continue;
                }
                throw new JsonParseException("Unknown attribute \"" + attributeName + "\"");
            }
            probe.addLine(line, instructionsCount, branchesCount);
            jsonReader.endObject();
        }
        jsonReader.endArray();
    }

    private void readMethods(@Nonnull JsonReader jsonReader, @Nonnull List<IMethodCoverage> methods) throws IOException {
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            IMethodCoverage methodCoverage = this.readMethod(jsonReader);
            if (methodCoverage == null) continue;
            methods.add(methodCoverage);
        }
        jsonReader.endArray();
    }

    @CheckForNull
    private IMethodCoverage readMethod(@Nonnull JsonReader jsonReader) throws IOException {
        int id = -1;
        String name = null;
        String desc = null;
        String signature = null;
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String attributeName = jsonReader.nextName();
            if ("id".equals(attributeName)) {
                id = jsonReader.nextInt();
                continue;
            }
            if ("name".equals(attributeName)) {
                name = jsonReader.nextString();
                continue;
            }
            if ("desc".equals(attributeName)) {
                desc = jsonReader.nextString();
                continue;
            }
            if ("signature".equals(attributeName)) {
                signature = jsonReader.nextString();
                continue;
            }
            throw new JsonParseException("Unknown attribute \"" + attributeName + "\"");
        }
        jsonReader.endObject();
        if (this.currentClassMapping != null) {
            assert (this.mappingFileLoader != null);
            String methodSignature = name + desc;
            String oldMethodSignature = this.currentClassMapping.getOriginalMethodSignature(methodSignature);
            if (oldMethodSignature == null) {
                return null;
            }
            int methodNameEndPos = oldMethodSignature.indexOf(40);
            assert (methodNameEndPos > 0);
            name = oldMethodSignature.substring(0, methodNameEndPos);
            desc = oldMethodSignature.substring(methodNameEndPos);
        }
        return new JackMethodCoverage(id, name, desc, signature);
    }
}

