/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import com.android.jack.tools.jacoco.ExitStatus;
import com.android.jack.tools.jacoco.Options;
import com.android.jack.tools.jacoco.Reporter;
import com.android.jack.tools.jacoco.ReporterException;
import com.android.sched.util.Version;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import org.kohsuke.args4j.spi.OptionHandler;

public class Main {
    public static void main(@Nonnull String[] args) {
        try {
            Options options = Options.parseCommandLine(Arrays.asList(args));
            if (options.askForHelp()) {
                Main.printUsage(System.out);
            } else if (options.askForVersion()) {
                Main.printVersion(System.out);
            } else {
                Reporter reporter = Main.createReporter(options);
                reporter.createReport();
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            CmdLineParser parser = e.getParser();
            if (parser != null) {
                Main.printUsage(System.err);
            } else {
                System.err.println("Try --help for help.");
            }
        }
        catch (ReporterException e) {
            e.printStackTrace(System.err);
            Main.printErrorAndExit(ExitStatus.USAGE_ERROR, e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            Main.printErrorAndExit(ExitStatus.INTERNAL_ERROR, e.getMessage());
        }
    }

    private static void printVersion(@Nonnull PrintStream out) {
        try {
            Version version = new Version("jack-jacoco-reporter", Main.class.getClassLoader());
            out.println("Jack Jacoco reporter: " + version.getVerboseVersion());
        }
        catch (IOException e) {
            throw new AssertionError("Failed to find reporter version", e);
        }
    }

    @Nonnull
    private static Reporter createReporter(@Nonnull Options options) throws ReporterException {
        Reporter reporter = new Reporter();
        reporter.setCoverageExecutionDataFiles(options.getCoverageExecutionFiles());
        reporter.setCoverageDescriptionFiles(options.getCoverageDescriptionFiles());
        reporter.setReportOutputDirectory(options.getReportOutputDirectory());
        reporter.setSourceFilesDirectories(options.getSourceFilesDirectories());
        reporter.setReportName(options.getReportName());
        reporter.setReportType(options.getReportType());
        reporter.setOutputEncoding(options.getOutputReportEncoding());
        reporter.setSourceFilesEncoding(options.getInputSourceFilesEncoding());
        reporter.setTabWidth(options.getTabWidth());
        File mappingFile = options.getMappingFile();
        if (mappingFile != null) {
            reporter.setMappingFile(mappingFile);
        }
        return reporter;
    }

    private static void printUsage(@Nonnull PrintStream printStream) {
        CmdLineParser parser = new CmdLineParser(new Options(), ParserProperties.defaults().withUsageWidth(100));
        StringBuilder oneLineUsage = new StringBuilder("Usage:");
        for (OptionHandler optionHandler : parser.getOptions()) {
            if (!optionHandler.option.required()) continue;
            oneLineUsage.append(' ');
            oneLineUsage.append(optionHandler.option.toString());
            oneLineUsage.append(' ');
            oneLineUsage.append(optionHandler.option.metaVar());
            if (!optionHandler.option.isMultiValued()) continue;
            oneLineUsage.append(" ...");
        }
        oneLineUsage.append(" [<options>]");
        printStream.println(oneLineUsage.toString());
        printStream.println();
        printStream.println("Options:");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        parser.printUsage(outputStream);
        printStream.append(outputStream.toString());
    }

    private static void printErrorAndExit(@Nonnull ExitStatus error, @Nonnull String msg) {
        System.err.println(msg);
        System.exit(error.getExitStatus());
    }
}

