/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import com.android.jack.tools.jacoco.NamingUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class MappingFileLoader {
    @Nonnull
    private static final char[] EMPTY_STOP_CHARS = new char[0];
    @Nonnull
    private static final char[] CLASSINFO_STOP_CHARS = new char[]{':'};
    @Nonnull
    private final Map<String, ClassMapping> oldToNewClassMapping = new HashMap<String, ClassMapping>();
    @Nonnull
    private final Map<String, ClassMapping> newToOldClassMapping = new HashMap<String, ClassMapping>();

    @CheckForNull
    public ClassMapping getClassMapping(@Nonnull String classBinaryName) {
        assert (classBinaryName.indexOf(46) < 0);
        assert (classBinaryName.indexOf(47) > 0);
        return this.newToOldClassMapping.get(classBinaryName);
    }

    public void load(@Nonnull InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        ClassMapping currentClassDesc = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).charAt(line.length() - 1) == ':') {
                currentClassDesc = this.readClassInfo(line);
                ClassMapping previous = this.newToOldClassMapping.put(currentClassDesc.getClassName(), currentClassDesc);
                assert (previous == null);
                previous = this.oldToNewClassMapping.put(currentClassDesc.getOriginalClassName(), currentClassDesc);
                assert (previous == null);
                continue;
            }
            if (line.indexOf(40) <= 0) continue;
            this.readMethodInfo(line, currentClassDesc);
        }
        this.updateMethodMappings();
    }

    private void updateMethodMappings() {
        assert (this.oldToNewClassMapping.size() == this.newToOldClassMapping.size());
        for (ClassMapping cd : this.newToOldClassMapping.values()) {
            cd.updateMethodMapping(this);
        }
    }

    @Nonnull
    private ClassMapping readClassInfo(@Nonnull String line) {
        try {
            int startIndex = MappingFileLoader.readWhiteSpaces(line, 0);
            int endIndex = this.readNameUntilSeparatorOrWhitespace(line, startIndex);
            String qualifiedOldClassName = line.substring(startIndex, endIndex);
            startIndex = MappingFileLoader.readWhiteSpaces(line, endIndex);
            startIndex = MappingFileLoader.readSeparator(line, startIndex);
            startIndex = MappingFileLoader.readWhiteSpaces(line, startIndex);
            endIndex = MappingFileLoader.readName(line, startIndex, CLASSINFO_STOP_CHARS);
            String newClassName = line.substring(startIndex, endIndex);
            return new ClassMapping(NamingUtils.fqNameToBinaryName(newClassName), NamingUtils.fqNameToBinaryName(qualifiedOldClassName));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AssertionError((Object)("Invalid line '" + line + "'"));
        }
    }

    private void readMethodInfo(@Nonnull String line, @Nonnull ClassMapping currentClassDesc) {
        int startIndex = MappingFileLoader.readWhiteSpaces(line, 0);
        startIndex = MappingFileLoader.readLineInfo(line, startIndex);
        startIndex = MappingFileLoader.readWhiteSpaces(line, startIndex);
        int endIndex = line.indexOf(41, startIndex);
        assert (endIndex > 0);
        String oldMethodDeclaration = line.substring(startIndex, endIndex + 1);
        startIndex = endIndex + 1;
        startIndex = MappingFileLoader.readWhiteSpaces(line, startIndex);
        startIndex = MappingFileLoader.readSeparator(line, startIndex);
        startIndex = MappingFileLoader.readWhiteSpaces(line, startIndex);
        endIndex = MappingFileLoader.readName(line, startIndex, EMPTY_STOP_CHARS);
        String newMethodName = line.substring(startIndex, endIndex);
        currentClassDesc.addMethod(oldMethodDeclaration, newMethodName);
    }

    @Nonnegative
    private int readNameUntilSeparatorOrWhitespace(@Nonnull String line, @Nonnegative int index) {
        int length = line.length();
        char c = line.charAt(index);
        while (!(Character.isWhitespace(c) || c == '-' && line.charAt(index + 1) == '>' || ++index >= length)) {
            c = line.charAt(index);
        }
        return index;
    }

    private static int readSeparator(@Nonnull String line, int index) {
        if (line.charAt(index) != '-' || line.charAt(index + 1) != '>') {
            throw new AssertionError();
        }
        return index + 2;
    }

    private static int readName(@Nonnull String line, @Nonnegative int index, @Nonnull char[] stopChars) {
        int length = line.length();
        char c = line.charAt(index);
        while (!Character.isWhitespace(c) && !MappingFileLoader.charInArray(c, stopChars) && ++index < length) {
            c = line.charAt(index);
        }
        return index;
    }

    private static boolean charInArray(char c, @Nonnull char[] array) {
        for (char c2 : array) {
            if (c != c2) continue;
            return true;
        }
        return false;
    }

    private static int readWhiteSpaces(@Nonnull String line, @Nonnegative int index) {
        while (Character.isWhitespace(line.charAt(index))) {
            ++index;
        }
        return index;
    }

    private static int readLineInfo(@Nonnull String line, @Nonnegative int index) {
        char c = line.charAt(index);
        while (Character.isDigit(c) || c == ':') {
            c = line.charAt(++index);
        }
        return index;
    }

    public static class ClassMapping {
        @Nonnull
        private final String className;
        @Nonnull
        private final String originalClassName;
        @CheckForNull
        private Map<String, String> oldToNewMethodMap = new HashMap<String, String>();
        @CheckForNull
        private Map<String, String> newToOldMethodMap = null;

        public ClassMapping(@Nonnull String className, @Nonnull String originalName) {
            this.className = className;
            this.originalClassName = originalName;
        }

        @Nonnull
        public String getClassName() {
            return this.className;
        }

        @Nonnull
        public String getOriginalClassName() {
            return this.originalClassName;
        }

        public void updateMethodMapping(@Nonnull MappingFileLoader loader) {
            assert (this.newToOldMethodMap == null);
            assert (this.oldToNewMethodMap != null);
            this.newToOldMethodMap = new HashMap<String, String>(this.oldToNewMethodMap.size());
            for (Map.Entry<String, String> e : this.oldToNewMethodMap.entrySet()) {
                String oldMethodDeclaration = e.getKey();
                String newMethodName = e.getValue();
                int returnTypeEndPos = oldMethodDeclaration.indexOf(32);
                String returnType = oldMethodDeclaration.substring(0, returnTypeEndPos);
                int oldMethodNameStartPos = MappingFileLoader.readWhiteSpaces(oldMethodDeclaration, returnTypeEndPos);
                int oldMethodNameEndPos = oldMethodDeclaration.indexOf(40, oldMethodNameStartPos);
                String oldMethodName = oldMethodDeclaration.substring(oldMethodNameStartPos, oldMethodNameEndPos);
                int parameterListStartPos = oldMethodNameEndPos + 1;
                int parameterListEndPos = oldMethodDeclaration.indexOf(41, parameterListStartPos);
                String parameterList = oldMethodDeclaration.substring(parameterListStartPos, parameterListEndPos);
                String[] paramTypes = parameterList.isEmpty() ? new String[]{} : parameterList.split(",");
                StringBuilder oldMethodSig = new StringBuilder(oldMethodName);
                StringBuilder newMethodSig = new StringBuilder(newMethodName);
                oldMethodSig.append('(');
                newMethodSig.append('(');
                for (String parameterType : paramTypes) {
                    parameterType = parameterType.trim();
                    String oldParameterTypeSig = NamingUtils.fqNameToSignature(parameterType);
                    String newParameterTypeSig = ClassMapping.oldToNewClassName(loader, oldParameterTypeSig);
                    oldMethodSig.append(oldParameterTypeSig);
                    newMethodSig.append(newParameterTypeSig);
                }
                oldMethodSig.append(')');
                newMethodSig.append(')');
                String oldReturnTypeSig = NamingUtils.fqNameToSignature(returnType);
                String newReturnTypeSig = ClassMapping.oldToNewClassName(loader, oldReturnTypeSig);
                oldMethodSig.append(oldReturnTypeSig);
                newMethodSig.append(newReturnTypeSig);
                this.newToOldMethodMap.put(newMethodSig.toString(), oldMethodSig.toString());
            }
            this.oldToNewMethodMap = null;
        }

        @Nonnull
        private static String oldToNewClassName(@Nonnull MappingFileLoader loader, @Nonnull String oldClassName) {
            int lastCharPos = oldClassName.length() - 1;
            if (oldClassName.charAt(lastCharPos) != ';') {
                return oldClassName;
            }
            if (oldClassName.charAt(0) == '[') {
                return '[' + ClassMapping.oldToNewClassName(loader, oldClassName.substring(1));
            }
            assert (oldClassName.charAt(0) == 'L');
            String binaryName = NamingUtils.signatureToBinaryName(oldClassName);
            ClassMapping cm = (ClassMapping)loader.oldToNewClassMapping.get(binaryName);
            if (cm != null) {
                return NamingUtils.binaryNameToSignature(cm.getClassName());
            }
            return oldClassName;
        }

        @CheckForNull
        public String getOriginalMethodSignature(@Nonnull String methodSignature) {
            assert (this.newToOldMethodMap != null);
            assert (this.oldToNewMethodMap == null);
            return this.newToOldMethodMap.get(methodSignature);
        }

        public void addMethod(@Nonnull String oldMethodDeclaration, @Nonnull String newMethodName) {
            assert (this.oldToNewMethodMap != null);
            assert (this.newToOldMethodMap == null);
            this.oldToNewMethodMap.put(oldMethodDeclaration, newMethodName);
        }
    }
}

