/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.jacoco.core.internal.analysis.MethodCoverageImpl;

class ProbeDescription {
    int id;
    @CheckForNull
    MethodCoverageImpl method;
    @Nonnull
    final List<Line> lines = new ArrayList<Line>();
    private static final int UNKNOWN_LINE = -1;

    ProbeDescription() {
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setMethod(@Nonnull MethodCoverageImpl method) {
        this.method = method;
    }

    public void addLine(int line, int instructionsCount, int branchesCount) {
        this.lines.add(new Line(line, instructionsCount, branchesCount));
    }

    @Nonnull
    public String toString() {
        return "Probe " + this.id + " lines=" + Arrays.toString(this.lines.toArray());
    }

    static class Line {
        final int line;
        @Nonnegative
        final int instructionsCount;
        @Nonnegative
        final int branchesCount;

        public Line(int line, int instructionsCount, int branchesCount) {
            if (line < -1) {
                throw new IllegalArgumentException("negative line");
            }
            if (instructionsCount < 0) {
                throw new IllegalArgumentException("negative instructionsCount");
            }
            if (branchesCount < 0) {
                throw new IllegalArgumentException("negative branchesCount");
            }
            this.line = line;
            this.instructionsCount = instructionsCount;
            this.branchesCount = branchesCount;
        }

        public String toString() {
            return "[line " + this.line + ": i=" + this.instructionsCount + ", b=" + this.branchesCount + "]";
        }
    }
}

