/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.tools.jacoco;

import com.android.jack.tools.jacoco.Constants;
import com.android.jack.tools.jacoco.JackCoverageAnalyzer;
import com.android.jack.tools.jacoco.MappingFileLoader;
import com.android.jack.tools.jacoco.ReportType;
import com.android.jack.tools.jacoco.ReporterException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.IBundleCoverage;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.DirectorySourceFileLocator;
import org.jacoco.report.FileMultiReportOutput;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.MultiSourceFileLocator;
import org.jacoco.report.csv.CSVFormatter;
import org.jacoco.report.html.HTMLFormatter;
import org.jacoco.report.xml.XMLFormatter;

public class Reporter {
    @Nonnull
    private List<File> coverageDescriptionFiles = Collections.emptyList();
    @Nonnull
    private List<File> coverageExecutionDataFiles = Collections.emptyList();
    @CheckForNull
    private File reportOutputDirectory;
    @Nonnull
    private List<File> sourceFilesDirectories = Collections.emptyList();
    @Nonnull
    private String reportName = "Report";
    @Nonnull
    private ReportType reportType = Constants.DEFAULT_REPORT_TYPE;
    @Nonnull
    private String outputEncoding = "UTF-8";
    @Nonnull
    private String sourceFilesEncoding = "UTF-8";
    @Nonnegative
    private int tabWidth = 4;
    @CheckForNull
    private File mappingFile;

    @Nonnull
    public List<File> getCoverageDescriptionFiles() {
        return this.coverageDescriptionFiles;
    }

    @Nonnull
    public List<File> getCoverageExecutionDataFiles() {
        return this.coverageExecutionDataFiles;
    }

    @CheckForNull
    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    @Nonnull
    public List<File> getSourceFilesDirectories() {
        return this.sourceFilesDirectories;
    }

    @Nonnull
    public String getReportName() {
        return this.reportName;
    }

    @Nonnull
    public ReportType getReportType() {
        return this.reportType;
    }

    @Nonnull
    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    @Nonnull
    public String getSourceFilesEncoding() {
        return this.sourceFilesEncoding;
    }

    @Nonnegative
    public int getTabWidth() {
        return this.tabWidth;
    }

    @CheckForNull
    public File getMappingFile() {
        return this.mappingFile;
    }

    public void setCoverageDescriptionFiles(@Nonnull List<File> coverageDescriptionFiles) throws ReporterException {
        for (File coverageDescriptionFile : coverageDescriptionFiles) {
            if (coverageDescriptionFile == null) {
                throw new NullPointerException();
            }
            Reporter.checkFileExists(coverageDescriptionFile);
            Reporter.checkCanReadFromFile(coverageDescriptionFile);
        }
        this.coverageDescriptionFiles = coverageDescriptionFiles;
    }

    public void setCoverageExecutionDataFiles(@Nonnull List<File> coverageExecutionDataFiles) throws ReporterException {
        for (File coverageExecutionDataFile : coverageExecutionDataFiles) {
            if (coverageExecutionDataFile == null) {
                throw new NullPointerException();
            }
            Reporter.checkFileExists(coverageExecutionDataFile);
            Reporter.checkCanReadFromFile(coverageExecutionDataFile);
        }
        this.coverageExecutionDataFiles = coverageExecutionDataFiles;
    }

    public void setReportOutputDirectory(@Nonnull File reportOutputDirectory) throws ReporterException {
        Reporter.checkDirectoryExists(reportOutputDirectory);
        Reporter.checkCanWriteToFile(reportOutputDirectory);
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public void setSourceFilesDirectories(@Nonnull List<File> sourceFilesDirectories) throws ReporterException {
        for (File sourceFilesDirectory : sourceFilesDirectories) {
            if (sourceFilesDirectory == null) {
                throw new NullPointerException();
            }
            Reporter.checkDirectoryExists(sourceFilesDirectory);
            Reporter.checkCanReadFromFile(sourceFilesDirectory);
        }
        this.sourceFilesDirectories = sourceFilesDirectories;
    }

    public void setReportName(@Nonnull String reportName) {
        this.reportName = reportName;
    }

    public void setReportType(@Nonnull ReportType reportType) {
        this.reportType = reportType;
    }

    public void setOutputEncoding(@Nonnull String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public void setSourceFilesEncoding(@Nonnull String sourceFilesEncoding) {
        this.sourceFilesEncoding = sourceFilesEncoding;
    }

    public void setTabWidth(@Nonnegative int tabWidth) {
        this.tabWidth = tabWidth;
    }

    public void setMappingFile(@Nonnull File mappingFile) throws ReporterException {
        Reporter.checkFileExists(mappingFile);
        Reporter.checkCanReadFromFile(mappingFile);
        this.mappingFile = mappingFile;
    }

    public void createReport() throws IOException, ReporterException {
        this.checkFiles();
        ExecFileLoader loader = this.loadCoverageExecutionFile();
        IBundleCoverage bundleCoverage = this.createBundleCoverage(loader);
        switch (this.reportType) {
            case HTML: {
                this.createHtmlReport(loader, bundleCoverage);
                break;
            }
            case XML: {
                this.createXmlReport(loader, bundleCoverage);
                break;
            }
            case CSV: {
                this.createCsvReport(loader, bundleCoverage);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown report type");
            }
        }
    }

    private void checkFiles() throws ReporterException {
        if (this.coverageDescriptionFiles.isEmpty()) {
            throw new ReporterException("Missing coverage description file (at least one is required)");
        }
        if (this.coverageExecutionDataFiles.isEmpty()) {
            throw new ReporterException("Missing coverage execution file");
        }
        if (this.reportOutputDirectory == null) {
            throw new ReporterException("Missing report output directory");
        }
    }

    @Nonnull
    private ExecFileLoader loadCoverageExecutionFile() throws IOException {
        ExecFileLoader loader = new ExecFileLoader();
        for (File coverageExecutionDataFile : this.coverageExecutionDataFiles) {
            loader.load(coverageExecutionDataFile);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private IBundleCoverage createBundleCoverage(@Nonnull ExecFileLoader loader) throws IOException {
        CoverageBuilder coverageBuilder = new CoverageBuilder();
        MappingFileLoader mappingFileLoader = null;
        if (this.mappingFile != null) {
            mappingFileLoader = new MappingFileLoader();
            FileInputStream in = new FileInputStream(this.mappingFile);
            try {
                mappingFileLoader.load(in);
            }
            finally {
                ((InputStream)in).close();
            }
        }
        JackCoverageAnalyzer analyzer = new JackCoverageAnalyzer(loader.getExecutionDataStore(), coverageBuilder, mappingFileLoader);
        for (File coverageDescriptionFile : this.coverageDescriptionFiles) {
            analyzer.analyze(coverageDescriptionFile);
        }
        return coverageBuilder.getBundle(this.reportName);
    }

    private void createHtmlReport(@Nonnull ExecFileLoader loader, @Nonnull IBundleCoverage bundleCoverage) throws IOException {
        HTMLFormatter htmlFormatter = new HTMLFormatter();
        htmlFormatter.setOutputEncoding(this.outputEncoding);
        IReportVisitor visitor = htmlFormatter.createVisitor(new FileMultiReportOutput(this.reportOutputDirectory));
        this.applyVisitor(loader, bundleCoverage, visitor);
        File indexHtmlFile = new File(this.reportOutputDirectory, "index.html");
        System.out.println("Created HTML report at " + indexHtmlFile.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createXmlReport(@Nonnull ExecFileLoader loader, @Nonnull IBundleCoverage bundleCoverage) throws IOException {
        XMLFormatter xmlFormatter = new XMLFormatter();
        xmlFormatter.setOutputEncoding(this.outputEncoding);
        File xmlReportFile = new File(this.reportOutputDirectory, "report.xml");
        FileOutputStream outputStream = new FileOutputStream(xmlReportFile);
        try {
            IReportVisitor visitor = xmlFormatter.createVisitor(outputStream);
            this.applyVisitor(loader, bundleCoverage, visitor);
            System.out.println("Created XML report at " + xmlReportFile.getAbsolutePath());
        }
        finally {
            ((OutputStream)outputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCsvReport(@Nonnull ExecFileLoader loader, @Nonnull IBundleCoverage bundleCoverage) throws IOException {
        CSVFormatter csvFormatter = new CSVFormatter();
        csvFormatter.setOutputEncoding(this.outputEncoding);
        File csvReportFile = new File(this.reportOutputDirectory, "report.csv");
        FileOutputStream outputStream = new FileOutputStream(csvReportFile);
        try {
            IReportVisitor visitor = csvFormatter.createVisitor(outputStream);
            this.applyVisitor(loader, bundleCoverage, visitor);
            System.out.println("Created CSV report at " + csvReportFile.getAbsolutePath());
        }
        finally {
            ((OutputStream)outputStream).close();
        }
    }

    private void applyVisitor(@Nonnull ExecFileLoader loader, @Nonnull IBundleCoverage bundleCoverage, @Nonnull IReportVisitor visitor) throws IOException {
        visitor.visitInfo(loader.getSessionInfoStore().getInfos(), loader.getExecutionDataStore().getContents());
        MultiSourceFileLocator sourceFileLocator = new MultiSourceFileLocator(this.tabWidth);
        for (File sourceFilesDirectory : this.sourceFilesDirectories) {
            sourceFileLocator.add(new DirectorySourceFileLocator(sourceFilesDirectory, this.sourceFilesEncoding, this.tabWidth));
        }
        visitor.visitBundle(bundleCoverage, sourceFileLocator);
        visitor.visitEnd();
    }

    private static void checkFileExists(@Nonnull File file) throws ReporterException {
        Reporter.checkFileExistsImpl(file, false);
    }

    private static void checkCanReadFromFile(@Nonnull File file) throws ReporterException {
        if (!file.canRead()) {
            throw new ReporterException(MessageFormat.format("Cannot read from file {0}", file));
        }
    }

    private static void checkCanWriteToFile(@Nonnull File file) throws ReporterException {
        if (!file.canWrite()) {
            throw new ReporterException(MessageFormat.format("Cannot write to file {0}", file));
        }
    }

    private static void checkDirectoryExists(@Nonnull File file) throws ReporterException {
        Reporter.checkFileExistsImpl(file, true);
        if (!file.isDirectory()) {
            throw new ReporterException(MessageFormat.format("File {0} is not a directory", file));
        }
    }

    private static void checkFileExistsImpl(@Nonnull File file, boolean expectDirectory) throws ReporterException {
        if (!file.exists()) {
            throw new ReporterException(MessageFormat.format("File {0} does not exist", file));
        }
        if (expectDirectory != file.isDirectory()) {
            if (expectDirectory) {
                throw new ReporterException(MessageFormat.format("File {0} is not a directory", file));
            }
            throw new ReporterException(MessageFormat.format("File {0} is a directory", file));
        }
    }
}

