/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.scheduler.genetic;

import com.android.sched.item.Component;
import com.android.sched.scheduler.GroupPlanCandidate;
import com.android.sched.scheduler.ManagedRunnable;
import com.android.sched.scheduler.ManagedSchedulable;
import com.android.sched.scheduler.Request;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.uncommons.watchmaker.framework.factories.AbstractCandidateFactory;

class PlanFactory<T extends Component>
extends AbstractCandidateFactory<GroupPlanCandidate<T>> {
    @Nonnull
    private final Request request;
    @Nonnull
    private final Class<T> rootRunOn;
    @Nonnull
    private final List<ManagedRunnable> runners = new ArrayList<ManagedRunnable>();

    PlanFactory(@Nonnull Request request, @Nonnull Class<T> rootRunOn) {
        this.request = request;
        this.rootRunOn = rootRunOn;
        for (Class production : request.getTargetProductions()) {
            for (ManagedSchedulable schedulable : request.getRunners()) {
                if (!schedulable.isRunnable() || !((ManagedRunnable)schedulable).getProductions().contains(production)) continue;
                this.runners.add((ManagedRunnable)schedulable);
            }
        }
    }

    @Nonnull
    public GroupPlanCandidate<T> generateRandomCandidate(Random rng) {
        ArrayList<ManagedRunnable> initial = new ArrayList<ManagedRunnable>(this.runners);
        return new GroupPlanCandidate<T>(this.request, this.rootRunOn, initial);
    }
}

