/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.util.config;

import com.android.sched.util.config.Config;
import com.android.sched.util.config.InternalConfig;
import com.android.sched.util.config.UninitializedConfig;
import com.android.sched.util.config.id.ObjectId;
import com.android.sched.util.config.id.PropertyId;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.util.log.tracer.TracerEventType;
import javax.annotation.Nonnull;

public class ThreadConfig {
    @Nonnull
    public static final StatisticId<Counter> TLS_READ = new StatisticId<Counter>("sched.config.tls.read", "Reading TLS to get current config", CounterImpl.class, Counter.class);
    @Nonnull
    private static final Config unitializedConfig = new UninitializedConfig();
    @Nonnull
    protected static final InheritableThreadLocal<Config> threadLocalConfig = new InheritableThreadLocal<Config>(){

        @Override
        protected Config initialValue() {
            return unitializedConfig;
        }
    };

    @Nonnull
    public static <T> T get(@Nonnull PropertyId<T> propertyId) {
        Config config = (Config)threadLocalConfig.get();
        ThreadConfig.updateStatistic(config);
        return config.get(propertyId);
    }

    @Nonnull
    public static <T> T get(@Nonnull ObjectId<T> objectId) {
        Config config = (Config)threadLocalConfig.get();
        ThreadConfig.updateStatistic(config);
        return config.get(objectId);
    }

    private static void updateStatistic(@Nonnull Config config) {
        Tracer tracer = ((InternalConfig)((Object)config)).getObjectIfAny(TracerFactory.TRACER);
        if (tracer != null && tracer.getCurrentEventType() != TracerEventType.NOEVENT) {
            tracer.getStatistic(TLS_READ).incValue();
        }
    }

    @Nonnull
    public static Config getConfig() {
        return (Config)threadLocalConfig.get();
    }

    public static void setConfig(@Nonnull Config config) {
        assert (config != null);
        threadLocalConfig.set(config);
    }

    public static void unsetConfig() {
        threadLocalConfig.remove();
    }
}

