/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.GenericInputOutputVFile;
import com.android.sched.vfs.GenericOutputVFile;
import com.android.sched.vfs.InputOutputVDir;
import com.android.sched.vfs.InputOutputVFile;
import com.android.sched.vfs.InputVElement;
import com.android.sched.vfs.OutputVDir;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VDir;
import com.android.sched.vfs.VElement;
import com.android.sched.vfs.VFile;
import com.android.sched.vfs.VPath;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;

public class GenericInputOutputVDir
implements InputOutputVDir {
    @Nonnull
    private final VDir dir;

    GenericInputOutputVDir(@Nonnull VDir dir) {
        this.dir = dir;
    }

    @Override
    public boolean isVDir() {
        return true;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.dir.getName();
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.dir.getLocation();
    }

    @Override
    @Nonnull
    public Collection<? extends InputVElement> list() {
        Collection<? extends VElement> vElements = this.dir.list();
        ArrayList<InputVElement> inputVElements = new ArrayList<InputVElement>(vElements.size());
        for (VElement vElement : vElements) {
            if (vElement.isVDir()) {
                inputVElements.add(new GenericInputOutputVDir((VDir)vElement));
                continue;
            }
            inputVElements.add(new GenericInputOutputVFile((VFile)vElement));
        }
        return inputVElements;
    }

    @Override
    @Nonnull
    public InputOutputVDir getInputVDir(@Nonnull VPath path) throws NotDirectoryException, NoSuchFileException {
        return new GenericInputOutputVDir(this.dir.getVDir(path));
    }

    @Override
    @Nonnull
    public InputOutputVFile getInputVFile(@Nonnull VPath path) throws NotFileException, NoSuchFileException, NotDirectoryException {
        return new GenericInputOutputVFile(this.dir.getVFile(path));
    }

    @Override
    @Nonnull
    public OutputVFile createOutputVFile(@Nonnull VPath path) throws CannotCreateFileException {
        return new GenericOutputVFile(this.dir.createVFile(path));
    }

    @Override
    @Nonnull
    public OutputVDir createOutputVDir(@Nonnull VPath path) throws CannotCreateFileException {
        return new GenericInputOutputVDir(this.dir.createVDir(path));
    }
}

