/*
 * Decompiled with CFR 0.152.
 */
package com.android.sched.vfs;

import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotDeleteFileException;
import com.android.sched.util.file.CannotGetModificationTimeException;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.NoSuchFileException;
import com.android.sched.util.file.NotDirectoryException;
import com.android.sched.util.file.NotFileException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.Location;
import com.android.sched.vfs.BaseVDir;
import com.android.sched.vfs.BaseVElement;
import com.android.sched.vfs.BaseVFS;
import com.android.sched.vfs.BaseVFile;
import com.android.sched.vfs.Capabilities;
import com.android.sched.vfs.VFS;
import com.android.sched.vfs.VPath;
import com.android.sched.vfs.WrongVFSTypeException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class PrefixedFS
extends BaseVFS<BaseVDir, BaseVFile>
implements VFS {
    @Nonnull
    private final BaseVFS<BaseVDir, BaseVFile> vfs;
    @Nonnull
    private final BaseVDir rootDir;

    public PrefixedFS(@Nonnull VFS vfs, @Nonnull VPath prefix, @Nonnull FileOrDirectory.Existence existence) throws CannotCreateFileException, NotDirectoryException, WrongVFSTypeException {
        BaseVDir rootDir;
        this.vfs = (BaseVFS)vfs;
        try {
            rootDir = ((BaseVDir)this.vfs.getRootDir()).getVDir(prefix);
            if (existence == FileOrDirectory.Existence.NOT_EXIST) {
                throw new WrongVFSTypeException(vfs, vfs.getLocation(), this.getDescription());
            }
        }
        catch (NoSuchFileException e) {
            if (existence == FileOrDirectory.Existence.MUST_EXIST) {
                throw new WrongVFSTypeException(vfs, vfs.getLocation(), this.getDescription(), e);
            }
            rootDir = ((BaseVDir)this.vfs.getRootDir()).createVDir(prefix);
        }
        this.rootDir = this.changeVFS(rootDir);
    }

    @Override
    @Nonnull
    public Location getLocation() {
        return this.rootDir.getLocation();
    }

    @Override
    public void close() {
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.vfs.getPath();
    }

    @Override
    @Nonnull
    public BaseVDir getRootDir() {
        return this.rootDir;
    }

    @Override
    @Nonnull
    InputStream openRead(@Nonnull BaseVFile file) throws WrongPermissionException {
        return this.vfs.openRead(file);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull BaseVFile file) throws WrongPermissionException {
        return this.openWrite(file, false);
    }

    @Override
    @Nonnull
    OutputStream openWrite(@Nonnull BaseVFile file, boolean append) throws WrongPermissionException {
        return this.vfs.openWrite(file, append);
    }

    @Override
    @Nonnull
    void delete(@Nonnull BaseVFile file) throws CannotDeleteFileException {
        this.vfs.delete(file);
    }

    @Override
    @Nonnull
    Collection<? extends BaseVElement> list(@Nonnull BaseVDir dir) {
        Collection<BaseVElement> elements = this.vfs.list(dir);
        for (BaseVElement element : elements) {
            element.changeVFS(this);
        }
        return elements;
    }

    @Override
    @Nonnull
    BaseVFile createVFile(@Nonnull BaseVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return this.changeVFS(this.vfs.createVFile(parent, name));
    }

    @Override
    @Nonnull
    BaseVDir createVDir(@Nonnull BaseVDir parent, @Nonnull String name) throws CannotCreateFileException {
        return this.changeVFS(this.vfs.createVDir(parent, name));
    }

    @Override
    @Nonnull
    BaseVDir getVDir(@Nonnull BaseVDir parent, @Nonnull String name) throws NotDirectoryException, NoSuchFileException {
        return this.changeVFS(this.vfs.getVDir(parent, name));
    }

    @Override
    @Nonnull
    BaseVFile getVFile(@Nonnull BaseVDir parent, @Nonnull String name) throws NotFileException, NoSuchFileException {
        return this.changeVFS(this.vfs.getVFile(parent, name));
    }

    @Override
    public boolean needsSequentialWriting() {
        return this.vfs.needsSequentialWriting();
    }

    @Override
    @Nonnull
    public String getDescription() {
        return "prefixed wrapper";
    }

    @Override
    @Nonnull
    public Set<Capabilities> getCapabilities() {
        return this.vfs.getCapabilities();
    }

    @Override
    boolean isEmpty(@Nonnull BaseVDir dir) {
        return this.vfs.isEmpty(dir);
    }

    @Override
    @Nonnull
    FileTime getLastModified(@Nonnull BaseVFile file) throws CannotGetModificationTimeException {
        return this.vfs.getLastModified(file);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVFile file) {
        return this.vfs.getVFileLocation(file);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVDir parent, @Nonnull String name) {
        return this.vfs.getVFileLocation(parent, name);
    }

    @Override
    @Nonnull
    Location getVFileLocation(@Nonnull BaseVDir parent, @Nonnull VPath path) {
        return this.vfs.getVFileLocation(parent, path);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir dir) {
        return this.vfs.getVDirLocation(dir);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir parent, @Nonnull String name) {
        return this.vfs.getVDirLocation(parent, name);
    }

    @Override
    @Nonnull
    Location getVDirLocation(@Nonnull BaseVDir parent, @Nonnull VPath path) {
        return this.vfs.getVDirLocation(parent, path);
    }

    @Override
    @Nonnull
    VPath getPathFromDir(@Nonnull BaseVDir parent, @Nonnull BaseVFile file) {
        return this.vfs.getPathFromDir(parent, file);
    }

    @Override
    @Nonnull
    VPath getPathFromRoot(@Nonnull BaseVFile file) {
        return this.vfs.getPathFromDir(this.rootDir, file);
    }

    @Nonnull
    private BaseVDir changeVFS(@Nonnull BaseVDir dir) {
        dir.changeVFS(this);
        return dir;
    }

    @Nonnull
    private BaseVFile changeVFS(@Nonnull BaseVFile file) {
        file.changeVFS(this);
        return file;
    }

    @Override
    @CheckForNull
    public String getInfoString() {
        return this.vfs.getInfoString();
    }

    public String toString() {
        return "prefixedFS >> " + this.vfs.toString();
    }
}

