/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack;

import com.android.sched.util.codec.CodecContext;
import com.android.sched.util.codec.EnumCodec;
import com.android.sched.util.codec.ParsingException;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.log.LogFormatter;
import com.android.sched.util.log.LoggerConfiguration;
import com.android.sched.util.log.LoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;

public class CLILogConfiguration {
    public static void setupLogs() throws LogConfigurationException {
        LogLevel level = LogLevel.WARNING;
        String stringLevel = System.getProperty("com.android.jack.log");
        if (stringLevel != null) {
            try {
                level = (LogLevel)new EnumCodec<LogLevel>(LogLevel.class).ignoreCase().checkString(new CodecContext(), stringLevel);
            }
            catch (ParsingException e) {
                throw new LogConfigurationException(e.getMessage());
            }
        }
        LoggerFactory.configure(level);
    }

    @VariableName(value="level")
    private static enum LogLevel implements LoggerConfiguration
    {
        ERROR{

            @Override
            public List<LoggerConfiguration.PackageLevel> getLevels() {
                return Arrays.asList(new LoggerConfiguration.PackageLevel("", Level.SEVERE));
            }
        }
        ,
        WARNING{

            @Override
            public List<LoggerConfiguration.PackageLevel> getLevels() {
                return Arrays.asList(new LoggerConfiguration.PackageLevel("", Level.WARNING));
            }
        }
        ,
        DEBUG{

            @Override
            public List<LoggerConfiguration.PackageLevel> getLevels() {
                return Arrays.asList(new LoggerConfiguration.PackageLevel("", Level.WARNING), new LoggerConfiguration.PackageLevel("com.android.jack", Level.FINE), new LoggerConfiguration.PackageLevel("com.android.sched", Level.WARNING));
            }
        }
        ,
        TRACE{

            @Override
            public List<LoggerConfiguration.PackageLevel> getLevels() {
                return Arrays.asList(new LoggerConfiguration.PackageLevel("", Level.FINEST));
            }
        };


        @Override
        public Collection<Handler> getHandlers() {
            ConsoleHandler handler = new ConsoleHandler();
            handler.setFormatter(new LogFormatter());
            handler.setLevel(Level.FINEST);
            return Collections.singletonList(handler);
        }
    }

    public static class LogConfigurationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public LogConfigurationException(String message) {
            super(message);
        }
    }
}

