/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis;

import com.android.jack.Options;
import com.android.jack.analysis.UsedVariableMarker;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Remove UsedVariableMarker.")
@Constraint(need={UsedVariableMarker.class, ControlFlowGraph.class})
@Transform(remove={UsedVariableMarker.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class UsedVariableRemover
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
        assert (cfg != null);
        for (BasicBlock bb : cfg.getNodes()) {
            for (JStatement stmt : bb.getStatements()) {
                stmt.removeMarker(UsedVariableMarker.class);
            }
        }
    }
}

