/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.dependency;

import com.android.jack.google.common.base.Joiner;
import com.android.jack.google.common.io.LineReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class Dependency {
    @Nonnull
    public static final String DEPENDENCY_FILE_EXTENSION = ".dep";
    @Nonnull
    protected static final String END_OF_MAP = "#";
    private static final char LIST_VALUE_SEPARATOR = ',';
    private static final char MAP_VALUE_SEPARATOR = ',';
    @Nonnull
    private static final Joiner mapValueJoiner = Joiner.on(',');
    @Nonnull
    private static final Joiner listValueJoiner = Joiner.on(',').useForNull("");

    @Nonnull
    protected Map<String, Set<String>> readMapOne2Many(@Nonnull LineReader lr) throws IOException {
        String line;
        HashMap<String, Set<String>> one2many = new HashMap<String, Set<String>>();
        while ((line = lr.readLine()) != null && !line.equals(END_OF_MAP)) {
            HashSet<String> values = new HashSet<String>();
            String key = line;
            line = lr.readLine();
            assert (line != null);
            LineParser lp = new LineParser(line);
            while (lp.hasNextToken()) {
                values.add(lp.nextToken(','));
            }
            one2many.put(key, values);
        }
        return one2many;
    }

    protected void writeMapOne2Many(@Nonnull PrintStream ps, @Nonnull Map<String, Set<String>> one2many) {
        for (Map.Entry<String, Set<String>> entry : one2many.entrySet()) {
            ps.print(entry.getKey());
            ps.println();
            StringBuilder sb = new StringBuilder();
            sb.append(mapValueJoiner.join(entry.getValue().iterator()));
            ps.print(sb.toString());
            ps.println();
        }
    }

    protected void writeList(@Nonnull PrintStream ps, @Nonnull List<String> list) {
        ps.print(listValueJoiner.join(list.iterator()));
    }

    @Nonnull
    protected List<String> readList(@Nonnull LineReader lr) throws IOException {
        ArrayList<String> digestValues = new ArrayList<String>();
        String line = lr.readLine();
        LineParser lp = new LineParser(line);
        while (lp.hasNextToken()) {
            digestValues.add(lp.nextToken(','));
        }
        return digestValues;
    }

    public abstract void read(@Nonnull Readable var1) throws IOException;

    private static class LineParser {
        @Nonnull
        private final String line;
        @Nonnegative
        private int lineCharIdx = 0;

        public LineParser(@Nonnull String line) {
            this.line = line;
        }

        public boolean hasNextToken() {
            return this.lineCharIdx < this.line.length();
        }

        @Nonnull
        public String nextToken(char separator) {
            if (this.lineCharIdx >= this.line.length()) {
                throw new NoSuchElementException();
            }
            int nextSeparatorIndex = this.line.indexOf(separator, this.lineCharIdx);
            if (nextSeparatorIndex == -1) {
                String result = this.line.substring(this.lineCharIdx, this.line.length());
                this.lineCharIdx = this.line.length() + 1;
                return result;
            }
            String result = this.line.substring(this.lineCharIdx, nextSeparatorIndex);
            this.lineCharIdx = nextSeparatorIndex + 1;
            return result;
        }
    }
}

