/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.tracer;

import com.android.jack.analysis.tracer.BaseTracerMarker;
import com.android.jack.analysis.tracer.TracerBrush;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNode;
import com.android.sched.marker.Marker;
import javax.annotation.Nonnull;

public abstract class AbstractTracerBrush<M extends BaseTracerMarker>
implements TracerBrush {
    private final boolean traceEnclosingMethod;
    @Nonnull
    private final Class<M> markerClass;
    @Nonnull
    private final Class<? extends Marker> seedMarkerClass;

    public AbstractTracerBrush(boolean traceEnclosingMethod, @Nonnull Class<M> markerClass, @Nonnull Class<? extends Marker> seedMarkerClass) {
        this.traceEnclosingMethod = traceEnclosingMethod;
        this.markerClass = markerClass;
        this.seedMarkerClass = seedMarkerClass;
    }

    @Override
    public boolean startTrace(@Nonnull JDefinedClassOrInterface type) {
        return this.markIfNecessary(type);
    }

    @Override
    public void endTrace(@Nonnull JDefinedClassOrInterface type) {
    }

    @Override
    public boolean startTrace(@Nonnull JMethod method) {
        return this.markIfNecessary(method);
    }

    @Override
    public void endTrace(@Nonnull JMethod method) {
    }

    @Override
    public boolean startTrace(@Nonnull JField field) {
        return this.markIfNecessary(field);
    }

    @Override
    public void endTrace(@Nonnull JField field) {
    }

    @Override
    public boolean startTraceSeed(@Nonnull JDefinedClassOrInterface type) {
        return this.isSeed(type);
    }

    @Override
    public void endTraceSeed(@Nonnull JDefinedClassOrInterface type) {
    }

    @Override
    public boolean startTraceSeed(@Nonnull JMethod method) {
        return this.isSeed(method);
    }

    @Override
    public void endTraceSeed(@Nonnull JMethod method) {
    }

    @Override
    public boolean startTraceSeed(@Nonnull JField field) {
        return this.isSeed(field);
    }

    @Override
    public void endTraceSeed(@Nonnull JField field) {
    }

    @Override
    public boolean startTraceOverridingMethod(@Nonnull JMethod method) {
        return this.traceMarked(method) && this.mustTraceOverridingMethod(method);
    }

    @Override
    public void endTraceOverridingMethod(@Nonnull JMethod method) {
    }

    @Override
    public boolean traceMarked(@Nonnull JNode node) {
        return this.isMarked(node);
    }

    @Override
    public void endTraceMarked(@Nonnull JNode node) {
    }

    protected boolean markIfNecessary(@Nonnull JNode node) {
        return node.addMarkerIfAbsent(this.createMarkerFor(node)) == null;
    }

    @Nonnull
    protected abstract M createMarkerFor(@Nonnull JNode var1);

    protected boolean isMarked(@Nonnull JNode node) {
        return node.containsMarker(this.markerClass);
    }

    protected boolean isSeed(@Nonnull JNode node) {
        return node.containsMarker(this.seedMarkerClass);
    }

    protected boolean mustTraceOverridingMethod(@Nonnull JMethod method) {
        BaseTracerMarker marker = (BaseTracerMarker)method.getMarker(this.markerClass);
        if (marker != null) {
            return marker.mustTraceOverridingMethods();
        }
        return false;
    }

    @Override
    public void setMustTraceOverridingMethods(@Nonnull JMethod method) {
        BaseTracerMarker marker = (BaseTracerMarker)method.getMarker(this.markerClass);
        assert (marker != null);
        marker.setMustTraceOverridingMethods(true);
    }

    @Override
    public boolean startTraceEnclosingMethod() {
        return this.traceEnclosingMethod;
    }

    @Override
    public void endTraceEnclosingMethod() {
    }
}

