/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.analysis.tracer;

import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.shrob.obfuscation.SubClassOrInterfaceMarker;
import com.android.sched.item.Description;
import com.android.sched.schedulable.Access;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import javax.annotation.Nonnull;

@Description(value="Fills the marker SubClassOrInterfaceMarker with the list of all classes and interfaces extending or implementing the marked type")
@Transform(add={SubClassOrInterfaceMarker.class})
@Access(value=JSession.class)
public class SubClassOrInterfaceFinder
implements RunnableSchedulable<JPackage> {
    private void addToSubClass(@Nonnull JDefinedClassOrInterface subClass, @Nonnull JClassOrInterface superClOrI) {
        SubClassOrInterfaceMarker newMarker;
        JNode castedSuperClOrI = (JNode)((Object)superClOrI);
        SubClassOrInterfaceMarker marker = castedSuperClOrI.getMarker(SubClassOrInterfaceMarker.class);
        if (marker == null && (marker = castedSuperClOrI.addMarkerIfAbsent(newMarker = new SubClassOrInterfaceMarker())) == null) {
            marker = newMarker;
        }
        assert (marker != null);
        marker.addSubClassOrInterface(subClass);
        if (superClOrI instanceof JDefinedClassOrInterface) {
            JClass superClass;
            if (superClOrI instanceof JDefinedClass && (superClass = ((JDefinedClass)superClOrI).getSuperClass()) != null) {
                this.addToSubClass(subClass, superClass);
            }
            for (JInterface i : ((JDefinedClassOrInterface)superClOrI).getImplements()) {
                this.addToSubClass(subClass, i);
            }
        }
    }

    @Override
    public void run(@Nonnull JPackage pack) {
        for (JClassOrInterface jClassOrInterface : pack.getTypes()) {
            JDefinedClass definedClass;
            JClass superClass;
            if (!(jClassOrInterface instanceof JDefinedClassOrInterface)) continue;
            JDefinedClassOrInterface definedType = (JDefinedClassOrInterface)jClassOrInterface;
            if (jClassOrInterface instanceof JDefinedClass && (superClass = (definedClass = (JDefinedClass)jClassOrInterface).getSuperClass()) != null) {
                this.addToSubClass(definedClass, superClass);
            }
            for (JInterface i : definedType.getImplements()) {
                this.addToSubClass(definedType, i);
            }
        }
    }
}

