/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.Options;
import com.android.jack.ir.HasSourceInfo;
import com.android.jack.ir.ast.JArrayType;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JClassLiteral;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDynamicCastOperation;
import com.android.jack.ir.ast.JInstanceOf;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JNewArray;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.reporting.Reportable;
import com.android.jack.reporting.Reporter;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.util.AndroidApiLevel;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Feature;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Support;
import com.android.sched.util.config.ThreadConfig;
import javax.annotation.Nonnull;

@Description(value="Check triggers of Dalvik bug about usage of arrays of protected inner classes.")
@Support(value={DalvikProtectedInnerCheck.class})
@Constraint(no={JCastOperation.WithIntersectionType.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class DalvikProtectedInnerChecker
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    private final boolean needCheck = ThreadConfig.get(Options.ANDROID_MIN_API_LEVEL).getReleasedLevel() < AndroidApiLevel.ReleasedLevel.K_WATCH.getLevel();

    @Override
    public void run(@Nonnull JMethod method) {
        if (!this.needCheck || method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        TypeAccessVisitor typeAccessVisitor = new TypeAccessVisitor(method.getEnclosingType());
        typeAccessVisitor.accept(method);
    }

    private static class TypeAccessVisitor
    extends JVisitor {
        @Nonnull
        private final JDefinedClassOrInterface currentType;

        public TypeAccessVisitor(@Nonnull JDefinedClassOrInterface currentType) {
            this.currentType = currentType;
        }

        @Override
        public void endVisit(@Nonnull JDynamicCastOperation cast) {
            this.check(cast.getType(), cast);
        }

        @Override
        public void endVisit(@Nonnull JClassLiteral constClass) {
            this.check(constClass.getRefType(), constClass);
        }

        @Override
        public void endVisit(@Nonnull JInstanceOf instanceOf) {
            this.check(instanceOf.getTestType(), instanceOf);
        }

        @Override
        public void endVisit(@Nonnull JNewArray newArray) {
            this.check(newArray.getArrayType(), newArray);
        }

        private void check(@Nonnull JType type, @Nonnull JNode node) {
            JDefinedClassOrInterface definedLeafType;
            JType leafType;
            if (type instanceof JArrayType && (leafType = ((JArrayType)type).getLeafType()) instanceof JDefinedClassOrInterface && (definedLeafType = (JDefinedClassOrInterface)leafType).isProtected() && !definedLeafType.getEnclosingPackage().equals(this.currentType.getEnclosingPackage())) {
                Jack.getSession().getReporter().report(Reporter.Severity.NON_FATAL, new RiskyAccessToArrayOfInner(definedLeafType, node));
            }
        }
    }

    private static class RiskyAccessToArrayOfInner
    implements Reportable,
    HasSourceInfo {
        @Nonnull
        private final JNode node;
        @Nonnull
        private final JDefinedClassOrInterface inner;

        private RiskyAccessToArrayOfInner(@Nonnull JDefinedClassOrInterface inner, @Nonnull JNode node) {
            this.node = node;
            this.inner = inner;
        }

        @Override
        @Nonnull
        public SourceInfo getSourceInfo() {
            return this.node.getSourceInfo();
        }

        @Override
        @Nonnull
        public String getMessage() {
            return "Usage of array of '" + Jack.getUserFriendlyFormatter().getName(this.inner) + "' may trigger an Android KitKat bug throwing an IllegalAccessError. As a workaround you may change the inner class visibility to public or remove its usages as array";
        }

        @Override
        @Nonnull
        public Reportable.ProblemLevel getDefaultProblemLevel() {
            return Reportable.ProblemLevel.WARNING;
        }
    }

    @Name(value="DalvikProtectedInnerCheck")
    @Description(value="Check triggers of Dalvik bug about usage of arrays of protected inner classes")
    public static class DalvikProtectedInnerCheck
    implements Feature {
    }
}

