/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Jack;
import com.android.jack.JackEventType;
import com.android.jack.Options;
import com.android.jack.backend.dex.DexWritingException;
import com.android.jack.backend.dex.MainDexMarker;
import com.android.jack.backend.dex.rop.CodeItemBuilder;
import com.android.jack.dx.dex.DexOptions;
import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.formatter.BinaryQualifiedNameFormatter;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.ir.formatter.UserFriendlyFormatter;
import com.android.jack.library.FileType;
import com.android.jack.library.FileTypeDoesNotExistException;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.OutputJackLibrary;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.tools.merger.JackMerger;
import com.android.jack.tools.merger.MergingOverflowException;
import com.android.jack.util.AndroidApiLevel;
import com.android.sched.util.codec.VariableName;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.HasLocation;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.OutputVFS;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@VariableName(value="writer")
public abstract class DexWritingTool {
    @Nonnull
    protected final Tracer tracer = TracerFactory.getTracer();
    @Nonnull
    private static final TypePackageAndMethodFormatter FORMATTER = Jack.getLookupFormatter();
    @Nonnull
    private static Logger logger = LoggerFactory.getLogger();
    private final boolean forceJumbo = ThreadConfig.get(CodeItemBuilder.FORCE_JUMBO);
    @Nonnull
    private final AndroidApiLevel apiLevel = ThreadConfig.get(Options.ANDROID_MIN_API_LEVEL);
    protected final boolean usePrebuilts = ThreadConfig.get(Options.USE_PREBUILT_FROM_LIBRARY);

    @Nonnull
    protected DexFile createDexFile() {
        DexOptions options = new DexOptions(this.apiLevel, this.forceJumbo);
        return new DexFile(options);
    }

    public abstract void write(@Nonnull OutputVFS var1) throws DexWritingException;

    protected void finishMerge(@Nonnull JackMerger merger, @Nonnull OutputVFile out) throws DexWritingException {
        try (Event event = this.tracer.open(JackEventType.DEX_MERGER_FINISH);){
            try {
                try (BufferedOutputStream os = new BufferedOutputStream(out.getOutputStream());){
                    merger.finish(os, out);
                }
                catch (IOException e) {
                    throw new CannotCloseException((HasLocation)out, (Exception)e);
                }
            }
            catch (CannotCloseException | CannotWriteException | WrongPermissionException e) {
                throw new DexWritingException(e);
            }
        }
    }

    protected void mergeDex(@Nonnull JackMerger merger, InputVFile inputDex) throws MergingOverflowException, DexWritingException {
        try {
            try (InputStream inputStream = inputDex.getInputStream();){
                merger.addDexFile(new DexBuffer(inputStream, inputDex.getLocation()));
            }
            catch (IOException e) {
                throw new CannotCloseException((HasLocation)inputDex, (Exception)e);
            }
        }
        catch (CannotCloseException | CannotReadException | WrongPermissionException e) {
            throw new DexWritingException(e);
        }
    }

    @Nonnull
    protected OutputVFile getOutputDex(@Nonnull OutputVFS outputVfs, int dexCount) throws DexWritingException {
        assert (dexCount >= 1);
        String dexName = dexCount == 1 ? "classes.dex" : "classes" + dexCount + ".dex";
        try {
            return outputVfs.getRootDir().createOutputVFile(new VPath(dexName, '/'));
        }
        catch (CannotCreateFileException e) {
            throw new DexWritingException(e);
        }
    }

    protected void fillDexLists(@Nonnull Set<MatchableInputVFile> mainDexList, @Nonnull List<MatchableInputVFile> anyDexList) {
        OutputJackLibrary jackOutputLibrary = Jack.getSession().getJackOutputLibrary();
        Collection<JDefinedClassOrInterface> typesToEmit = Jack.getSession().getTypesToEmit();
        ArrayList<JDefinedClassOrInterface> anyTypeList = new ArrayList<JDefinedClassOrInterface>(typesToEmit.size());
        for (JDefinedClassOrInterface type : typesToEmit) {
            if (type.containsMarker(MainDexMarker.class)) {
                mainDexList.add(new MatchableInputVFile(this.getDexInputVFileOfType(jackOutputLibrary, type)));
                continue;
            }
            anyTypeList.add(type);
        }
        Collections.sort(anyTypeList, new Comparator<JDefinedClassOrInterface>(){

            @Override
            public int compare(@Nonnull JDefinedClassOrInterface first, @Nonnull JDefinedClassOrInterface second) {
                return FORMATTER.getName(first).compareTo(FORMATTER.getName(second));
            }
        });
        for (JDefinedClassOrInterface type : anyTypeList) {
            anyDexList.add(new MatchableInputVFile(this.getDexInputVFileOfType(jackOutputLibrary, type)));
        }
        if (this.usePrebuilts) {
            DexWritingTool.addOrphanDexFiles(null, mainDexList, new HashSet<MatchableInputVFile>(anyDexList));
        }
    }

    @Nonnull
    protected InputVFile getDexInputVFileOfType(@Nonnull OutputJackLibrary jackOutputLibrary, @Nonnull JDefinedClassOrInterface type) {
        InputVFile inputVFile = null;
        Location location = type.getLocation();
        try {
            InputLibrary inputLibrary;
            if (location instanceof TypeInInputLibraryLocation && (inputLibrary = ((TypeInInputLibraryLocation)location).getInputLibrary()).containsFileType(FileType.PREBUILT)) {
                inputVFile = inputLibrary.getFile(FileType.PREBUILT, new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type), '/'));
            }
            if (inputVFile == null) {
                inputVFile = jackOutputLibrary.getFile(FileType.PREBUILT, new VPath(BinaryQualifiedNameFormatter.getFormatter().getName(type), '/'));
            }
        }
        catch (FileTypeDoesNotExistException e) {
            throw new AssertionError((Object)(UserFriendlyFormatter.getFormatter().getName(type) + " does not exist"));
        }
        return inputVFile;
    }

    static void addOrphanDexFiles(@CheckForNull OutputJackLibrary outputLibrary, @Nonnull Set<MatchableInputVFile> mainDexToMerge) {
        DexWritingTool.addOrphanDexFiles(outputLibrary, mainDexToMerge, Collections.emptySet());
    }

    static void addOrphanDexFiles(@CheckForNull OutputJackLibrary outputLibrary, @Nonnull Set<MatchableInputVFile> mainDexToMerge, @Nonnull Set<MatchableInputVFile> othersDexToMerge) {
        for (InputLibrary inputLibrary : Jack.getSession().getImportedLibraries()) {
            if (!(inputLibrary instanceof InputJackLibrary)) continue;
            InputJackLibrary inputJackLibrary = (InputJackLibrary)inputLibrary;
            if (outputLibrary != null && outputLibrary.containsLibraryLocation(inputJackLibrary.getLocation())) continue;
            Iterator<InputVFile> dexFileIt = inputJackLibrary.iterator(FileType.PREBUILT);
            while (dexFileIt.hasNext()) {
                InputVFile dexFile = dexFileIt.next();
                String dexFilePath = dexFile.getPathFromRoot().getPathAsString('/');
                int indexOfDexExtension = dexFilePath.indexOf(".dex");
                if (indexOfDexExtension == -1) continue;
                String type = dexFilePath.substring(0, dexFilePath.indexOf(".dex"));
                try {
                    inputJackLibrary.getFile(FileType.JAYCE, new VPath(type, '/'));
                }
                catch (FileTypeDoesNotExistException e) {
                    MatchableInputVFile orphanDex = new MatchableInputVFile(dexFile);
                    if (othersDexToMerge.contains(orphanDex)) continue;
                    mainDexToMerge.add(orphanDex);
                }
            }
        }
    }

    static class MatchableInputVFile {
        @Nonnull
        private final InputVFile inputVFile;

        public MatchableInputVFile(@Nonnull InputVFile inputVFile) {
            this.inputVFile = inputVFile;
        }

        public final boolean equals(@CheckForNull Object obj) {
            if (!(obj instanceof MatchableInputVFile)) {
                return false;
            }
            return this.inputVFile.getPathFromRoot().equals(((MatchableInputVFile)obj).getInputVFile().getPathFromRoot());
        }

        public final int hashCode() {
            return this.inputVFile.getPathFromRoot().hashCode();
        }

        @Nonnull
        public InputVFile getInputVFile() {
            return this.inputVFile;
        }
    }
}

