/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.Options;
import com.android.jack.backend.dex.AnnotationBuilder;
import com.android.jack.backend.dex.annotations.tag.ParameterMetadataAnnotation;
import com.android.jack.backend.dex.annotations.tag.ParameterMetadataFeature;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.dx.dex.file.ClassDefItem;
import com.android.jack.dx.rop.annotation.Annotations;
import com.android.jack.dx.rop.annotation.AnnotationsList;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.scheduling.feature.SourceVersion8;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.ClassDefItemMarker;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Synchronized;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.Optional;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.ToSupport;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.ThreadConfig;
import java.util.Collection;
import javax.annotation.Nonnull;

@Description(value="Builds the rop annotations of a method")
@Synchronized
@Constraint(need={ClassDefItemMarker.class, ClassDefItemMarker.Method.class})
@Transform(add={ClassDefItemMarker.MethodAnnotation.class}, modify={ClassDefItemMarker.class})
@Use(value={AnnotationBuilder.class})
@Optional(value={@ToSupport(feature={SourceVersion8.class}, add={@Constraint(no={JAnnotation.RepeatedAnnotation.class})}), @ToSupport(feature={ParameterMetadataFeature.class}, add={@Constraint(need={ParameterMetadataAnnotation.class})})})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class MethodAnnotationBuilder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);

    @Override
    public synchronized void run(@Nonnull JMethod method) {
        Annotations ropAnnotations;
        JDefinedClassOrInterface declaringClass = method.getEnclosingType();
        if (!this.filter.accept(this.getClass(), method)) {
            return;
        }
        Collection<JAnnotation> annotations = method.getAnnotations();
        if (!annotations.isEmpty() && (ropAnnotations = new AnnotationBuilder().createAnnotations(annotations)).size() > 0) {
            ClassDefItemMarker classDefItemMarker = declaringClass.getMarker(ClassDefItemMarker.class);
            assert (classDefItemMarker != null);
            ClassDefItem classDefItem = classDefItemMarker.getClassDefItem();
            classDefItem.addMethodAnnotations(RopHelper.createMethodRef(method), ropAnnotations);
        }
        AnnotationsList annotationsList = new AnnotationsList(method.getParams().size());
        int annotationIndex = 0;
        boolean hasParamAnnotations = false;
        for (JParameter param : method.getParams()) {
            Collection<JAnnotation> paramAnnotations = param.getAnnotations();
            hasParamAnnotations |= paramAnnotations.size() > 0;
            Annotations annotation = new AnnotationBuilder().createAnnotations(paramAnnotations);
            annotationsList.set(annotationIndex++, annotation);
        }
        if (hasParamAnnotations) {
            assert (annotationsList.size() > 0);
            ClassDefItemMarker classDefItemMarker = declaringClass.getMarker(ClassDefItemMarker.class);
            assert (classDefItemMarker != null);
            ClassDefItem classDefItem = classDefItemMarker.getClassDefItem();
            classDefItem.addParameterAnnotations(RopHelper.createMethodRef(method), annotationsList);
        }
    }
}

