/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex;

import com.android.jack.JackIOException;
import com.android.jack.backend.dex.DexInLibraryProduct;
import com.android.jack.backend.dex.DexWriter;
import com.android.jack.backend.dex.DexWritingTool;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.FileType;
import com.android.jack.library.LibraryLocation;
import com.android.jack.library.OutputJackLibrary;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Produce;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotCreateFileException;
import com.android.sched.util.file.CannotReadException;
import com.android.sched.util.file.CannotWriteException;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.vfs.InputVFile;
import com.android.sched.vfs.OutputVFile;
import com.android.sched.vfs.VPath;
import java.util.HashSet;
import javax.annotation.Nonnull;

@Description(value="Write an orphan dex from an imported library to an output library")
@Name(value="OrphanDexFileWriter")
@Produce(value={DexInLibraryProduct.class})
public class OrphanDexFileWriter
extends DexWriter
implements RunnableSchedulable<JSession> {
    @Override
    public void run(@Nonnull JSession session) {
        HashSet<DexWritingTool.MatchableInputVFile> prebuiltOrphanDexFiles = new HashSet<DexWritingTool.MatchableInputVFile>();
        OutputJackLibrary outputLibrary = session.getJackOutputLibrary();
        DexWritingTool.addOrphanDexFiles(outputLibrary, prebuiltOrphanDexFiles);
        for (DexWritingTool.MatchableInputVFile matchableInput : prebuiltOrphanDexFiles) {
            OutputVFile vFile;
            InputVFile in = matchableInput.getInputVFile();
            String dexFilePath = in.getPathFromRoot().getPathAsString('/');
            int indexOfDexExtension = dexFilePath.indexOf(".dex");
            assert (indexOfDexExtension != -1);
            String type = dexFilePath.substring(0, dexFilePath.indexOf(".dex"));
            try {
                vFile = outputLibrary.createFile(FileType.PREBUILT, new VPath(type, '/'));
            }
            catch (CannotCreateFileException e) {
                throw new JackIOException("Could not create Dex file in output " + ((LibraryLocation)outputLibrary.getLocation()).getDescription() + " for type " + type, e);
            }
            try {
                vFile.copy(in);
            }
            catch (CannotCloseException | CannotReadException | CannotWriteException | WrongPermissionException e) {
                throw new JackIOException("Could not copy Dex file from " + in.getLocation().getDescription() + " to " + vFile.getLocation().getDescription(), e);
            }
        }
    }
}

