/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.backend.dex.rop;

import com.android.jack.JackEventType;
import com.android.jack.Options;
import com.android.jack.backend.dex.rop.RopBasicBlockManager;
import com.android.jack.backend.dex.rop.RopBuilderVisitor;
import com.android.jack.backend.dex.rop.RopHelper;
import com.android.jack.backend.dex.rop.RopRegisterManager;
import com.android.jack.cfg.BasicBlock;
import com.android.jack.cfg.CatchBasicBlock;
import com.android.jack.cfg.ConditionalBasicBlock;
import com.android.jack.cfg.ControlFlowGraph;
import com.android.jack.cfg.NormalBasicBlock;
import com.android.jack.cfg.PeiBasicBlock;
import com.android.jack.cfg.ReturnBasicBlock;
import com.android.jack.cfg.SwitchBasicBlock;
import com.android.jack.cfg.ThrowBasicBlock;
import com.android.jack.dx.dex.DexOptions;
import com.android.jack.dx.dex.code.DalvCode;
import com.android.jack.dx.dex.code.RopTranslator;
import com.android.jack.dx.dex.file.CodeItem;
import com.android.jack.dx.rop.code.DexTranslationAdvice;
import com.android.jack.dx.rop.code.Insn;
import com.android.jack.dx.rop.code.InsnList;
import com.android.jack.dx.rop.code.LocalVariableExtractor;
import com.android.jack.dx.rop.code.LocalVariableInfo;
import com.android.jack.dx.rop.code.PlainCstInsn;
import com.android.jack.dx.rop.code.PlainInsn;
import com.android.jack.dx.rop.code.RegisterSpec;
import com.android.jack.dx.rop.code.RegisterSpecList;
import com.android.jack.dx.rop.code.RopMethod;
import com.android.jack.dx.rop.code.Rops;
import com.android.jack.dx.rop.code.SourcePosition;
import com.android.jack.dx.rop.cst.CstInteger;
import com.android.jack.dx.rop.type.StdTypeList;
import com.android.jack.dx.rop.type.Type;
import com.android.jack.dx.rop.type.TypeList;
import com.android.jack.dx.ssa.Optimizer;
import com.android.jack.dx.util.IntList;
import com.android.jack.ir.SideEffectOperation;
import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAsgOperation;
import com.android.jack.ir.ast.JAssertStatement;
import com.android.jack.ir.ast.JCastOperation;
import com.android.jack.ir.ast.JConcatOperation;
import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JConditionalOperation;
import com.android.jack.ir.ast.JExceptionRuntimeValue;
import com.android.jack.ir.ast.JFieldInitializer;
import com.android.jack.ir.ast.JLoop;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodBody;
import com.android.jack.ir.ast.JMultiExpression;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JSwitchStatement;
import com.android.jack.ir.ast.JThis;
import com.android.jack.ir.ast.marker.ThrownExceptionMarker;
import com.android.jack.library.DumpInLibrary;
import com.android.jack.library.PrebuiltCompatibility;
import com.android.jack.scheduling.filter.TypeWithoutPrebuiltFilter;
import com.android.jack.scheduling.marker.DexCodeMarker;
import com.android.jack.transformations.EmptyClinit;
import com.android.jack.transformations.InvalidDefaultBridgeInInterfaceRemoved;
import com.android.jack.transformations.ast.BooleanTestOutsideIf;
import com.android.jack.transformations.ast.ImplicitBoxingAndUnboxing;
import com.android.jack.transformations.ast.ImplicitCast;
import com.android.jack.transformations.ast.InitInNewArray;
import com.android.jack.transformations.ast.JPrimitiveClassLiteral;
import com.android.jack.transformations.ast.MultiDimensionNewArray;
import com.android.jack.transformations.ast.NewInstanceRemoved;
import com.android.jack.transformations.ast.RefAsStatement;
import com.android.jack.transformations.ast.UnassignedValues;
import com.android.jack.transformations.ast.inner.InnerAccessor;
import com.android.jack.transformations.ast.switches.UselessSwitches;
import com.android.jack.transformations.booleanoperators.FallThroughMarker;
import com.android.jack.transformations.cast.SourceCast;
import com.android.jack.transformations.rop.cast.RopLegalCast;
import com.android.jack.transformations.threeaddresscode.ThreeAddressCodeForm;
import com.android.jack.util.AndroidApiLevel;
import com.android.jack.util.filter.Filter;
import com.android.sched.item.Description;
import com.android.sched.item.Name;
import com.android.sched.schedulable.Constraint;
import com.android.sched.schedulable.RunnableSchedulable;
import com.android.sched.schedulable.Transform;
import com.android.sched.schedulable.Use;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.log.Event;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
@Description(value="Builds CodeItem from JMethod")
@Name(value="CodeItemBuilder")
@Constraint(need={ControlFlowGraph.class, JExceptionRuntimeValue.class, NewInstanceRemoved.class, ThreeAddressCodeForm.class, RopLegalCast.class, InnerAccessor.class, InvalidDefaultBridgeInInterfaceRemoved.class}, no={BooleanTestOutsideIf.class, InitInNewArray.class, JAsgOperation.class, JPrimitiveClassLiteral.class, JMultiExpression.class, JConditionalExpression.class, JFieldInitializer.class, JConcatOperation.class, JLoop.class, SideEffectOperation.class, UnassignedValues.class, RefAsStatement.class, MultiDimensionNewArray.class, JSwitchStatement.SwitchWithEnum.class, ImplicitBoxingAndUnboxing.class, ImplicitCast.class, JAssertStatement.class, JConditionalOperation.class, EmptyClinit.class, UselessSwitches.class, SourceCast.class, JCastOperation.WithIntersectionType.class})
@Transform(add={DexCodeMarker.class})
@Use(value={RopHelper.class})
@com.android.sched.schedulable.Filter(value={TypeWithoutPrebuiltFilter.class})
public class CodeItemBuilder
implements RunnableSchedulable<JMethod> {
    @Nonnull
    public static final BooleanPropertyId EMIT_SYNTHETIC_LOCAL_DEBUG_INFO = ((BooleanPropertyId)BooleanPropertyId.create("jack.dex.debug.vars.synthetic", "Emit synthetic local variable debug info into generated dex").addDefaultValue(Boolean.FALSE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);
    @Nonnull
    public static final BooleanPropertyId DEX_OPTIMIZE = ((BooleanPropertyId)BooleanPropertyId.create("jack.dex.optimize", "Define if Dex optimizations are activated").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);
    @Nonnull
    public static final BooleanPropertyId FORCE_JUMBO = ((BooleanPropertyId)BooleanPropertyId.create("jack.dex.forcejumbo", "Force string opcodes to be emitted as jumbo in dex").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);
    @Nonnull
    public static final BooleanPropertyId OPTIMIZE_BRANCHES = ((BooleanPropertyId)BooleanPropertyId.create("jack.dex.optimizebranches", "Remove redundant branches in dex").addDefaultValue(Boolean.TRUE).addCategory(DumpInLibrary.class)).addCategory(PrebuiltCompatibility.class);
    @Nonnull
    private final Filter<JMethod> filter = ThreadConfig.get(Options.METHOD_FILTER);
    private final boolean emitSyntheticLocalDebugInfo = ThreadConfig.get(EMIT_SYNTHETIC_LOCAL_DEBUG_INFO);
    private final boolean emitLocalDebugInfo = ThreadConfig.get(Options.EMIT_LOCAL_DEBUG_INFO);
    private final boolean runDxOptimizations = ThreadConfig.get(DEX_OPTIMIZE);
    private final boolean forceJumbo = ThreadConfig.get(FORCE_JUMBO);
    private final boolean removeRedundantConditionalBranch = ThreadConfig.get(OPTIMIZE_BRANCHES);
    @Nonnull
    private final AndroidApiLevel apiLevel = ThreadConfig.get(Options.ANDROID_MIN_API_LEVEL);
    private final boolean emitLineNumberTable = ThreadConfig.get(Options.EMIT_LINE_NUMBER_DEBUG_INFO);
    @Nonnull
    private final Tracer tracer = TracerFactory.getTracer();

    @Override
    public void run(@Nonnull JMethod method) {
        if (method.isNative() || method.isAbstract() || !this.filter.accept(this.getClass(), method)) {
            return;
        }
        try (Event event = this.tracer.open(JackEventType.DX_BACKEND);){
            DalvCode dalvCode;
            Object ropBuilder;
            RopRegisterManager ropReg = new RopRegisterManager(this.emitLocalDebugInfo, this.emitSyntheticLocalDebugInfo);
            ControlFlowGraph cfg = method.getMarker(ControlFlowGraph.class);
            assert (cfg != null);
            RopBasicBlockManager ropBb = new RopBasicBlockManager(this.getMaxLabel(cfg));
            assert (cfg.getEntryNode().getSuccessors().size() == 1);
            BasicBlock firstBlockOfCode = cfg.getEntryNode().getSuccessors().get(0);
            assert (firstBlockOfCode != null);
            this.addSetupBlocks(method, ropReg, ropBb, firstBlockOfCode.getId());
            JAbstractMethodBody body = method.getBody();
            assert (body instanceof JMethodBody);
            if (method.getType() != JPrimitiveType.JPrimitiveTypeEnum.VOID.getType()) {
                ropReg.createReturnReg(method.getType());
            }
            for (BasicBlock bb : cfg.getNodes()) {
                InsnList il;
                IntList successors;
                IntList successors2;
                SourcePosition lastStmtsourcePosition;
                List<Insn> instructions;
                block71: {
                    BasicBlock secondary;
                    BasicBlock primary;
                    InsnList il2;
                    block73: {
                        block72: {
                            if (bb == cfg.getEntryNode()) continue;
                            ropBuilder = new RopBuilderVisitor(ropReg, bb, this.apiLevel);
                            assert (!bb.getStatements().isEmpty());
                            ((RopBuilderVisitor)ropBuilder).accept(bb.getStatements());
                            instructions = ((RopBuilderVisitor)ropBuilder).getInstructions();
                            assert (instructions != null);
                            JStatement lastStmt = bb.getLastInstruction();
                            lastStmtsourcePosition = RopHelper.getSourcePosition(lastStmt);
                            if (bb instanceof ReturnBasicBlock) {
                                il2 = this.createInsnList(instructions, 0);
                                il2.setImmutable();
                                ropBb.createBasicBlock(bb.getId(), il2, IntList.EMPTY, -1);
                                continue;
                            }
                            if (!(bb instanceof ConditionalBasicBlock)) break block71;
                            il2 = this.createInsnList(instructions, 0);
                            il2.setImmutable();
                            primary = ((ConditionalBasicBlock)bb).getThenBlock();
                            secondary = ((ConditionalBasicBlock)bb).getElseBlock();
                            FallThroughMarker ftm = lastStmt.getMarker(FallThroughMarker.class);
                            if (ftm == null) break block72;
                            switch (ftm.getFallThrough()) {
                                case ELSE: {
                                    primary = ((ConditionalBasicBlock)bb).getElseBlock();
                                    secondary = ((ConditionalBasicBlock)bb).getThenBlock();
                                    break block73;
                                }
                                case THEN: {
                                    primary = ((ConditionalBasicBlock)bb).getThenBlock();
                                    secondary = ((ConditionalBasicBlock)bb).getElseBlock();
                                    break block73;
                                }
                                default: {
                                    throw new AssertionError();
                                }
                            }
                        }
                        primary = ((ConditionalBasicBlock)bb).getThenBlock();
                        secondary = ((ConditionalBasicBlock)bb).getElseBlock();
                    }
                    assert (primary != null);
                    assert (secondary != null);
                    int primarySuccessor = primary.getId();
                    successors2 = IntList.makeImmutable(primarySuccessor, secondary.getId());
                    ropBb.createBasicBlock(bb.getId(), il2, successors2, primarySuccessor);
                    continue;
                }
                if (bb instanceof ThrowBasicBlock) {
                    assert (bb.getSuccessors().size() >= 1);
                    ThrowBasicBlock throwBlock = (ThrowBasicBlock)bb;
                    InsnList il3 = this.createInsnList(instructions, 0);
                    il3.setImmutable();
                    successors = new IntList();
                    int primarySuccessor = -1;
                    if (!throwBlock.getExceptionBlocks().isEmpty()) {
                        this.addCatchBlockSuccessors(throwBlock.getExceptionBlocks(), successors);
                    }
                    successors.setImmutable();
                    ropBb.createBasicBlock(bb.getId(), il3, successors, primarySuccessor);
                    continue;
                }
                if (bb instanceof PeiBasicBlock) {
                    SourcePosition sourcePosition;
                    boolean needsGoto;
                    assert (bb.getSuccessors().size() >= 2);
                    PeiBasicBlock peiBlock = (PeiBasicBlock)bb;
                    Insn lastInstruction = instructions.get(instructions.size() - 1);
                    List<Insn> extraInstructions = ((RopBuilderVisitor)ropBuilder).getExtraInstructions();
                    assert (extraInstructions != null);
                    il = this.createInsnList(instructions, 0);
                    il.setImmutable();
                    int extraBlockLabel = ropBb.getAvailableLabel();
                    successors2 = new IntList();
                    this.addCatchBlockSuccessors(peiBlock.getExceptionBlocks(), successors2);
                    successors2.add(extraBlockLabel);
                    successors2.setImmutable();
                    ropBb.createBasicBlock(bb.getId(), il, successors2, extraBlockLabel);
                    int indexInstruction = 0;
                    if (extraInstructions.isEmpty()) {
                        needsGoto = true;
                        sourcePosition = lastInstruction.getPosition();
                        il = new InsnList(1);
                    } else {
                        Insn extraInsn = extraInstructions.get(0);
                        needsGoto = extraInstructions.get(extraInstructions.size() - 1).getOpcode().getBranchingness() == 1;
                        il = new InsnList(extraInstructions.size() + (needsGoto ? 1 : 0));
                        for (Insn inst : extraInstructions) {
                            il.set(indexInstruction++, inst);
                        }
                        sourcePosition = extraInsn.getPosition();
                    }
                    if (needsGoto) {
                        il.set(indexInstruction++, new PlainInsn(Rops.GOTO, sourcePosition, null, RegisterSpecList.EMPTY));
                    }
                    il.setImmutable();
                    BasicBlock primarySuccessor = ((PeiBasicBlock)bb).getTarget();
                    assert (primarySuccessor != null);
                    successors2 = IntList.makeImmutable(primarySuccessor.getId());
                    ropBb.createBasicBlock(extraBlockLabel, il, successors2, primarySuccessor.getId());
                    continue;
                }
                if (bb instanceof SwitchBasicBlock) {
                    IntList successors3 = new IntList();
                    for (BasicBlock succ : ((SwitchBasicBlock)bb).getCasesBlock()) {
                        successors3.add(succ.getId());
                    }
                    int defaultIdBlock = ((SwitchBasicBlock)bb).getDefaultBlock().getId();
                    successors3.add(defaultIdBlock);
                    successors3.setImmutable();
                    InsnList il4 = this.createInsnList(instructions, 0);
                    il4.setImmutable();
                    ropBb.createBasicBlock(bb.getId(), il4, successors3, successors3.get(successors3.size() - 1));
                    continue;
                }
                if (bb instanceof NormalBasicBlock) {
                    List<BasicBlock> bbSuccessors = bb.getSuccessors();
                    assert (bbSuccessors.size() == 1);
                    int primarySuccessor = bbSuccessors.get(0).getId();
                    successors = IntList.makeImmutable(primarySuccessor);
                    il = this.createInsnList(instructions, 1);
                    PlainInsn gotoInstruction = new PlainInsn(Rops.GOTO, lastStmtsourcePosition, null, RegisterSpecList.EMPTY);
                    il.set(instructions.size(), gotoInstruction);
                    il.setImmutable();
                    ropBb.createBasicBlock(bb.getId(), il, successors, primarySuccessor);
                    continue;
                }
                throw new AssertionError((Object)"Not yet supported");
            }
            RopMethod ropMethod = new RopMethod(ropBb.getBasicBlockList(), ropBb.getSpecialLabel(-1), false);
            if (this.runDxOptimizations) {
                Event optEvent = this.tracer.open(JackEventType.DX_OPTIMIZATION);
                ropBuilder = null;
                try {
                    ropMethod = Optimizer.optimize(ropMethod, this.getParameterWordCount(method), method.isStatic(), true, this.removeRedundantConditionalBranch, DexTranslationAdvice.THE_ONE);
                }
                catch (Throwable throwable) {
                    ropBuilder = throwable;
                    throw throwable;
                }
                finally {
                    if (optEvent != null) {
                        if (ropBuilder != null) {
                            try {
                                optEvent.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)ropBuilder).addSuppressed(throwable);
                            }
                        } else {
                            optEvent.close();
                        }
                    }
                }
            }
            try (Event dopEvent = this.tracer.open(JackEventType.DOP_CREATION);){
                dalvCode = this.createCode(method, ropMethod);
            }
            method.addMarker(new DexCodeMarker(new CodeItem(RopHelper.createMethodRef(method), dalvCode, method.isStatic(), CodeItemBuilder.createThrows(method))));
        }
    }

    private void addCatchBlockSuccessors(@Nonnull List<CatchBasicBlock> catchBlocks, @Nonnull IntList successors) {
        for (CatchBasicBlock catchblock : catchBlocks) {
            int catchTypeCount = 0;
            int catchTypesSize = catchblock.getCatchTypes().size();
            while (catchTypeCount++ < catchTypesSize) {
                successors.add(catchblock.getId());
            }
        }
    }

    @Nonnull
    private static TypeList createThrows(@Nonnull JMethod method) {
        ThrownExceptionMarker marker = method.getMarker(ThrownExceptionMarker.class);
        if (marker != null) {
            return RopHelper.createTypeList(marker.getThrownExceptions());
        }
        return StdTypeList.EMPTY;
    }

    private int getMaxLabel(ControlFlowGraph cfg) {
        int maxLabel = -1;
        for (BasicBlock bb : cfg.getNodes()) {
            int bbId = bb.getId();
            if (bbId <= maxLabel) continue;
            maxLabel = bbId;
        }
        return ++maxLabel;
    }

    @Nonnull
    private InsnList createInsnList(@Nonnull List<Insn> instructions, @Nonnegative int extraSize) {
        InsnList il = new InsnList(instructions.size() + extraSize);
        int indexInstruction = 0;
        for (Insn instruction : instructions) {
            il.set(indexInstruction++, instruction);
        }
        return il;
    }

    private void addSetupBlocks(@Nonnull JMethod method, @Nonnull RopRegisterManager ropReg, @Nonnull RopBasicBlockManager ropBb, @Nonnegative int entryNodeId) {
        InsnList insns;
        SourcePosition pos = SourcePosition.NO_INFO;
        List<JParameter> parameters = method.getParams();
        int indexParam = 0;
        int sz = parameters.size();
        if (method.isStatic()) {
            insns = new InsnList(sz + 1);
        } else {
            insns = new InsnList(sz + 2);
            JThis jThis = method.getThis();
            assert (jThis != null);
            RegisterSpec thisReg = ropReg.createThisReg(jThis);
            PlainCstInsn insn = new PlainCstInsn(Rops.opMoveParam(thisReg.getType()), pos, thisReg, RegisterSpecList.EMPTY, CstInteger.make(thisReg.getReg()));
            insns.set(indexParam++, insn);
        }
        for (JParameter param : parameters) {
            RegisterSpec paramReg = ropReg.getOrCreateRegisterSpec(param);
            PlainCstInsn insn = new PlainCstInsn(Rops.opMoveParam(paramReg.getType()), pos, paramReg, RegisterSpecList.EMPTY, CstInteger.make(paramReg.getReg()));
            insns.set(indexParam, insn);
            ++indexParam;
        }
        insns.set(indexParam, new PlainInsn(Rops.GOTO, pos, null, RegisterSpecList.EMPTY));
        insns.setImmutable();
        ropBb.createBasicBlock(ropBb.getSpecialLabel(-1), insns, IntList.makeImmutable(entryNodeId), entryNodeId);
    }

    @Nonnull
    private DalvCode createCode(@Nonnull JMethod method, @Nonnull RopMethod ropMethod) {
        DexOptions options = new DexOptions(this.apiLevel, this.forceJumbo);
        int paramSize = this.getParameterWordCount(method);
        LocalVariableInfo lvInfo = this.emitLocalDebugInfo ? LocalVariableExtractor.extract(ropMethod) : null;
        int positionListKind = this.emitLineNumberTable ? 2 : 1;
        return RopTranslator.translate(ropMethod, positionListKind, lvInfo, paramSize, options);
    }

    @Nonnegative
    private int getParameterWordCount(@Nonnull JMethod method) {
        int wordCount = method.isStatic() ? 0 : Type.OBJECT.getWordCount();
        for (JParameter param : method.getParams()) {
            wordCount += RopHelper.convertTypeToDx(param.getType()).getWordCount();
        }
        return wordCount;
    }
}

