/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex;

import com.android.jack.dx.util.DexException;
import com.android.jack.util.AndroidApiLevel;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class DexFormat {
    @Nonnegative
    private static final int API_ANDROID_N = 24;
    @Nonnull
    public static final String DEX_IN_JAR_NAME = "classes.dex";
    @Nonnull
    public static final String MAGIC_PREFIX = "dex\n";
    @Nonnull
    public static final String MAGIC_SUFFIX = "\u0000";
    @Nonnull
    private static final String DEX_VERSION_PREFIX = "0";
    @Nonnegative
    public static final int O_BETA2_DEX_VERSION = 38;
    @Nonnegative
    public static final int ANDROID_N_DEX_VERSION = 37;
    @Nonnegative
    public static final int ANDROID_PRE_N_DEX_VERSION = 35;
    @Nonnegative
    public static final int ENDIAN_TAG = 305419896;
    @Nonnegative
    public static final int MAX_MEMBER_IDX = 65535;
    @Nonnegative
    public static final int MAX_TYPE_IDX = 65535;
    @Nonnegative
    public static final int MAX_PROTOTYPE_IDX = 65535;

    private DexFormat() {
    }

    @Nonnegative
    public static int getDexVersion(@Nonnull byte[] magic) {
        if (magic.length != 8) {
            return -1;
        }
        if (magic[0] != 100 || magic[1] != 101 || magic[2] != 120 || magic[3] != 10 || magic[7] != 0) {
            return -1;
        }
        String version = "" + (char)magic[4] + (char)magic[5] + (char)magic[6];
        if (version.equals("038")) {
            return 38;
        }
        if (version.equals("037")) {
            return 37;
        }
        if (version.equals("035")) {
            return 35;
        }
        throw new DexException("Unexpected magic: " + Arrays.toString(magic));
    }

    @Nonnull
    public static String dexVersionToMagic(@Nonnegative int dexVersion) {
        return "dex\n0" + dexVersion + MAGIC_SUFFIX;
    }

    @Nonnegative
    public static int apiToDexVersion(@Nonnull AndroidApiLevel targetApiLevel) {
        if (targetApiLevel.isReleasedLevel()) {
            switch (targetApiLevel.getReleasedLevel()) {
                case 24: {
                    return 37;
                }
            }
            return 35;
        }
        switch (targetApiLevel.getProvisionalLevel()) {
            case O_BETA1: {
                return 37;
            }
            case O_BETA2: {
                return 38;
            }
        }
        throw new UnsupportedOperationException();
    }
}

