/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.EncodedArrayItem;
import com.android.jack.dx.dex.file.IndexedItem;
import com.android.jack.dx.dex.file.ItemType;
import com.android.jack.dx.dex.file.MethodHandleIdItem;
import com.android.jack.dx.dex.file.MethodHandleIdsSection;
import com.android.jack.dx.dex.file.ProtoIdItem;
import com.android.jack.dx.dex.file.ProtoIdsSection;
import com.android.jack.dx.dex.file.StringIdsSection;
import com.android.jack.dx.rop.cst.CstCallSiteRef;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.Hex;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CallSiteIdItem
extends IndexedItem {
    @Nonnull
    private final CstCallSiteRef callSiteRef;
    @Nonnull
    private EncodedArrayItem encodedArray;

    public CallSiteIdItem(@Nonnull CstCallSiteRef callSiteRef) {
        this.callSiteRef = callSiteRef;
        this.encodedArray = new EncodedArrayItem(callSiteRef.getCstArray());
    }

    @Override
    @Nonnull
    public ItemType itemType() {
        return ItemType.TYPE_CALL_SITE_ITEM;
    }

    @Override
    @Nonnegative
    public int writeSize() {
        return 4;
    }

    @Override
    public void addContents(@Nonnull DexFile file) {
        StringIdsSection stringIds = file.getStringIds();
        ProtoIdsSection protoIds = file.getProtoIds();
        MethodHandleIdsSection methodHandleIds = file.getMethodHandleIds();
        stringIds.intern(this.callSiteRef.getTargetMethodName());
        protoIds.intern(this.callSiteRef.getCallSitePrototype().getPrototype());
        methodHandleIds.intern(this.callSiteRef.getMethodHandle());
        this.encodedArray = file.getByteData().intern(this.encodedArray);
    }

    @Override
    public void writeTo(@Nonnull DexFile file, @Nonnull AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(0, this.indexString());
            out.annotate(4, "  encoded_array_absolute_offset: " + this.encodedArray.getAbsoluteOffset());
            MethodHandleIdItem methodHandle = (MethodHandleIdItem)file.findItemOrNull(this.callSiteRef.getMethodHandle());
            out.annotate(0, "  method_handle_idx:             " + Hex.u2(methodHandle.getIndex()) + " // " + methodHandle.getCstMethodHandleRef().toHuman());
            out.annotate(0, "  target_method_name:            " + this.callSiteRef.getTargetMethodName().getString());
            ProtoIdItem methodType = (ProtoIdItem)file.findItemOrNull(this.callSiteRef.getCallSitePrototype());
            out.annotate(0, "  method_type_idx:               " + Hex.u2(methodType.getIndex()) + " // " + methodType.toHuman());
            out.annotate(0, "  extra_args:                    " + this.callSiteRef.getExtraArgs().getList().toHuman("{", ",", "}"));
        }
        out.writeInt(this.encodedArray.getAbsoluteOffset());
    }
}

