/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.dex.file;

import com.android.jack.dx.dex.file.DexFile;
import com.android.jack.dx.dex.file.IndexedItem;
import com.android.jack.dx.dex.file.ItemType;
import com.android.jack.dx.dex.file.MemberIdItem;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import com.android.jack.dx.util.AnnotatedOutput;
import com.android.jack.dx.util.Hex;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class MethodHandleIdItem
extends IndexedItem {
    @Nonnull
    private final CstMethodHandleRef cstMethodHandleRef;

    public MethodHandleIdItem(@Nonnull CstMethodHandleRef cstMethodHandleRef) {
        assert (cstMethodHandleRef != null);
        this.cstMethodHandleRef = cstMethodHandleRef;
    }

    @Override
    @Nonnull
    public ItemType itemType() {
        return ItemType.TYPE_METHOD_HANDLE_ITEM;
    }

    @Override
    @Nonnegative
    public int writeSize() {
        return 8;
    }

    @Override
    public void addContents(@Nonnull DexFile file) {
        file.internIfAppropriate(this.cstMethodHandleRef.getMemberRef());
    }

    @Nonnull
    public CstMethodHandleRef getCstMethodHandleRef() {
        return this.cstMethodHandleRef;
    }

    @Override
    public void writeTo(@Nonnull DexFile file, @Nonnull AnnotatedOutput out) {
        MemberIdItem memberItem = (MemberIdItem)file.findItemOrNull(this.cstMethodHandleRef.getMemberRef());
        if (out.annotates()) {
            out.annotate(0, this.indexString());
            out.annotate(2, "  method_handle_kind:  " + (Object)((Object)this.cstMethodHandleRef.getKind()));
            out.annotate(2, "  reserved");
            out.annotate(2, "  field_or_method_idx: " + Hex.u2(memberItem.getIndex()) + " // " + memberItem.getRef().toHuman());
            out.annotate(2, "  reserved");
        }
        out.writeShort(this.cstMethodHandleRef.getKind().getValue());
        out.writeShort(0);
        out.writeShort(memberItem.getIndex());
        out.writeShort(0);
    }
}

