/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.io;

import com.android.jack.dx.dex.TableOfContents;
import com.android.jack.dx.io.ClassDef;
import com.android.jack.dx.io.DexBuffer;
import com.android.jack.dx.io.FieldId;
import com.android.jack.dx.io.MethodId;
import com.android.jack.dx.io.ProtoId;
import com.android.sched.util.file.CannotCloseException;
import com.android.sched.util.file.CannotReadException;
import java.io.File;

public final class DexIndexPrinter {
    private final DexBuffer dexBuffer;
    private final TableOfContents tableOfContents;

    public DexIndexPrinter(File file) throws CannotReadException, CannotCloseException {
        this.dexBuffer = new DexBuffer(file);
        this.tableOfContents = this.dexBuffer.getTableOfContents();
    }

    private void printMap() {
        for (TableOfContents.Section section : this.tableOfContents.sections) {
            if (section.off == -1) continue;
            System.out.println("section " + Integer.toHexString(section.type) + " off=" + Integer.toHexString(section.off) + " size=" + Integer.toHexString(section.size) + " byteCount=" + Integer.toHexString(section.byteCount));
        }
    }

    private void printStrings() {
        int index = 0;
        for (String string : this.dexBuffer.strings()) {
            System.out.println("string " + index + ": " + string);
            ++index;
        }
    }

    private void printTypeIds() {
        int index = 0;
        for (Integer type : this.dexBuffer.typeIds()) {
            System.out.println("type " + index + ": " + this.dexBuffer.strings().get(type));
            ++index;
        }
    }

    private void printProtoIds() {
        int index = 0;
        for (ProtoId protoId : this.dexBuffer.protoIds()) {
            System.out.println("proto " + index + ": " + protoId);
            ++index;
        }
    }

    private void printFieldIds() {
        int index = 0;
        for (FieldId fieldId : this.dexBuffer.fieldIds()) {
            System.out.println("field " + index + ": " + fieldId);
            ++index;
        }
    }

    private void printMethodIds() {
        int index = 0;
        for (MethodId methodId : this.dexBuffer.methodIds()) {
            System.out.println("methodId " + index + ": " + methodId);
            ++index;
        }
    }

    private void printTypeLists() {
        if (this.tableOfContents.typeLists.off == -1) {
            System.out.println("No type lists");
            return;
        }
        DexBuffer.Section in = this.dexBuffer.open(this.tableOfContents.typeLists.off);
        for (int i = 0; i < this.tableOfContents.typeLists.size; ++i) {
            int size = in.readInt();
            System.out.print("Type list i=" + i + ", size=" + size + ", elements=");
            for (int t = 0; t < size; ++t) {
                System.out.print(" " + this.dexBuffer.typeNames().get(in.readShort()));
            }
            if (size % 2 == 1) {
                in.readShort();
            }
            System.out.println();
        }
    }

    private void printClassDefs() {
        int index = 0;
        for (ClassDef classDef : this.dexBuffer.classDefs()) {
            System.out.println("class def " + index + ": " + classDef);
            ++index;
        }
    }

    public static void main(String[] args) throws CannotReadException, CannotCloseException {
        DexIndexPrinter indexPrinter = new DexIndexPrinter(new File(args[0]));
        indexPrinter.printMap();
        indexPrinter.printStrings();
        indexPrinter.printTypeIds();
        indexPrinter.printProtoIds();
        indexPrinter.printFieldIds();
        indexPrinter.printMethodIds();
        indexPrinter.printTypeLists();
        indexPrinter.printClassDefs();
    }
}

