/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.cst;

import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstMemberRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.type.Prototype;
import com.android.jack.dx.rop.type.Type;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public abstract class CstBaseMethodRef
extends CstMemberRef {
    @Nonnull
    private final Prototype prototype;
    @CheckForNull
    private Prototype instancePrototype;

    CstBaseMethodRef(@Nonnull Type definingClass, @Nonnull CstString name, @Nonnull Prototype prototype) {
        super(definingClass, name);
        this.prototype = prototype;
        this.instancePrototype = null;
    }

    @Nonnull
    public final Prototype getPrototype() {
        return this.prototype;
    }

    @Nonnull
    public final Prototype getPrototype(boolean isStatic) {
        if (isStatic) {
            return this.prototype;
        }
        if (this.instancePrototype == null) {
            Type thisType = this.getDefiningClass();
            this.instancePrototype = this.prototype.withFirstParameter(thisType);
        }
        return this.instancePrototype;
    }

    @Override
    protected final int compareTo0(Constant other) {
        int cmp = super.compareTo0(other);
        if (cmp != 0) {
            return cmp;
        }
        CstBaseMethodRef otherMethod = (CstBaseMethodRef)other;
        return this.prototype.compareTo(otherMethod.prototype);
    }

    @Override
    @Nonnull
    public final Type getType() {
        return this.prototype.getReturnType();
    }

    public final int getParameterWordCount(boolean isStatic) {
        return this.getPrototype(isStatic).getParameterTypes().getWordCount();
    }

    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CstBaseMethodRef otherRef = (CstBaseMethodRef)other;
        return this.getDefiningClass().equals(otherRef.getDefiningClass()) && this.getName().equals(otherRef.getName()) && this.prototype.equals(otherRef.prototype);
    }

    public final int hashCode() {
        return this.getDefiningClass().hashCode() * 31 + this.getName().hashCode() * 31 + this.getType().hashCode();
    }

    @Override
    @Nonnull
    public final String toHuman() {
        return this.getDefiningClass().toHuman() + '.' + this.getName().toHuman() + ':' + this.prototype.toString();
    }
}

