/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.cst;

import com.android.jack.dx.dex.file.ValueEncoder;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstArray;
import com.android.jack.dx.rop.cst.CstMethodHandleRef;
import com.android.jack.dx.rop.cst.CstPrototypeRef;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.TypedConstant;
import com.android.jack.dx.rop.type.Type;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CstCallSiteRef
extends TypedConstant {
    @Nonnegative
    private static final int METHOD_HANDLE_IDX = 0;
    @Nonnegative
    private static final int TARGET_METHOD_NAME_IDX = 1;
    @Nonnegative
    private static final int CALL_SITE_IDX = 2;
    @Nonnegative
    private static final int EXTRA_ARGS_IDX = 3;
    @Nonnull
    private final CstArray callSite;

    public CstCallSiteRef(@Nonnull CstArray callSite) {
        this.callSite = callSite;
    }

    public CstCallSiteRef(@Nonnull CstMethodHandleRef methodHandle, @Nonnull String targetMethodName, @Nonnull CstPrototypeRef callSitePrototype, @CheckForNull CstArray extraArgs) {
        CstArray.List list = new CstArray.List(3 + (extraArgs != null ? extraArgs.getList().size() : 0));
        list.set(0, methodHandle);
        list.set(1, new CstString(targetMethodName));
        list.set(2, callSitePrototype);
        if (extraArgs != null) {
            CstArray.List extraArgList = extraArgs.getList();
            for (int idx = 0; idx < extraArgList.size(); ++idx) {
                list.set(3 + idx, extraArgList.get(idx));
            }
        }
        list.setImmutable();
        this.callSite = new CstArray(list);
    }

    @Override
    protected int compareTo0(@Nonnull Constant other) {
        assert (other instanceof CstCallSiteRef);
        int cmp = this.getTargetMethodName().compareTo(((CstCallSiteRef)other).getTargetMethodName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getCallSitePrototype().compareTo(((CstCallSiteRef)other).getCallSitePrototype());
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.getCallSitePrototype().getType();
    }

    @Override
    @Nonnull
    public String typeName() {
        return "call-site";
    }

    @Nonnull
    public String toString() {
        return this.typeName() + '{' + this.toHuman() + '}';
    }

    @Override
    @Nonnull
    public String toHuman() {
        return this.getMethodHandle().toHuman() + ", " + this.getTargetMethodName() + ", " + this.getCallSitePrototype().toHuman();
    }

    @Nonnull
    public CstMethodHandleRef getMethodHandle() {
        return (CstMethodHandleRef)this.callSite.getList().get(0);
    }

    @Nonnull
    public CstString getTargetMethodName() {
        return (CstString)this.callSite.getList().get(1);
    }

    @Nonnull
    public CstPrototypeRef getCallSitePrototype() {
        return (CstPrototypeRef)this.callSite.getList().get(2);
    }

    @Nonnull
    public CstArray getExtraArgs() {
        CstArray.List callSiteList = this.callSite.getList();
        CstArray.List list = new CstArray.List(callSiteList.size() - 3);
        for (int idx = 3; idx < callSiteList.size(); ++idx) {
            list.set(idx - 3, callSiteList.get(idx));
        }
        list.setImmutable();
        return new CstArray(list);
    }

    @Nonnull
    public CstArray getCstArray() {
        return this.callSite;
    }

    @Override
    @Nonnull
    public ValueEncoder.ValueType getEncodedValueType() {
        throw new UnsupportedOperationException();
    }
}

