/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.cst;

import com.android.jack.dx.dex.file.ValueEncoder;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstMemberRef;
import com.android.jack.dx.rop.cst.TypedConstant;
import com.android.jack.dx.rop.type.Type;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class CstMethodHandleRef
extends TypedConstant {
    @Nonnull
    private final MethodHandleKind kind;
    @Nonnull
    private final CstMemberRef memberRef;

    public CstMethodHandleRef(@Nonnull MethodHandleKind kind, @Nonnull CstMemberRef memberRef) {
        this.kind = kind;
        this.memberRef = memberRef;
    }

    public final boolean equals(@Nonnull Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CstMethodHandleRef otherCst = (CstMethodHandleRef)other;
        return this.kind.equals((Object)otherCst.kind) && this.memberRef.equals(otherCst.memberRef);
    }

    public final int hashCode() {
        return this.kind.hashCode() * 31 ^ this.memberRef.hashCode();
    }

    @Override
    protected int compareTo0(@Nonnull Constant other) {
        assert (other instanceof CstMethodHandleRef);
        int cmp = this.kind.compareTo(((CstMethodHandleRef)other).kind);
        if (cmp != 0) {
            return cmp;
        }
        return this.memberRef.compareTo(((CstMethodHandleRef)other).memberRef);
    }

    @Override
    public boolean isCategory2() {
        return false;
    }

    @Override
    @Nonnull
    public Type getType() {
        return this.memberRef.getType();
    }

    @Override
    @Nonnull
    public String typeName() {
        return "method-handle";
    }

    @Nonnull
    public String toString() {
        return this.typeName() + '{' + this.toHuman() + '}';
    }

    @Override
    @Nonnull
    public String toHuman() {
        return this.kind.name() + ", " + this.memberRef.toHuman();
    }

    @Nonnull
    public MethodHandleKind getKind() {
        return this.kind;
    }

    @Nonnull
    public CstMemberRef getMemberRef() {
        return this.memberRef;
    }

    @Override
    @Nonnull
    public ValueEncoder.ValueType getEncodedValueType() {
        return ValueEncoder.ValueType.VALUE_METHOD_HANDLE;
    }

    public static final class MethodHandleKind
    extends Enum<MethodHandleKind> {
        public static final /* enum */ MethodHandleKind PUT_STATIC = new MethodHandleKind(0);
        public static final /* enum */ MethodHandleKind GET_STATIC = new MethodHandleKind(1);
        public static final /* enum */ MethodHandleKind PUT_INSTANCE = new MethodHandleKind(2);
        public static final /* enum */ MethodHandleKind GET_INSTANCE = new MethodHandleKind(3);
        public static final /* enum */ MethodHandleKind INVOKE_STATIC = new MethodHandleKind(4);
        public static final /* enum */ MethodHandleKind INVOKE_INSTANCE = new MethodHandleKind(5);
        public static final /* enum */ MethodHandleKind INVOKE_CONSTRUCTOR = new MethodHandleKind(6);
        private final int value;
        private static final /* synthetic */ MethodHandleKind[] $VALUES;

        public static MethodHandleKind[] values() {
            return (MethodHandleKind[])$VALUES.clone();
        }

        public static MethodHandleKind valueOf(String name) {
            return Enum.valueOf(MethodHandleKind.class, name);
        }

        private MethodHandleKind(int value) {
            this.value = value;
        }

        @Nonnegative
        public int getValue() {
            return this.value;
        }

        @Nonnull
        public static MethodHandleKind getKind(@Nonnegative int value) {
            MethodHandleKind kind;
            switch (value) {
                case 0: {
                    kind = PUT_STATIC;
                    break;
                }
                case 1: {
                    kind = GET_STATIC;
                    break;
                }
                case 2: {
                    kind = PUT_INSTANCE;
                    break;
                }
                case 3: {
                    kind = GET_INSTANCE;
                    break;
                }
                case 4: {
                    kind = INVOKE_STATIC;
                    break;
                }
                case 5: {
                    kind = INVOKE_INSTANCE;
                    break;
                }
                case 6: {
                    kind = INVOKE_CONSTRUCTOR;
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            assert (kind.getValue() == value);
            return kind;
        }

        static {
            $VALUES = new MethodHandleKind[]{PUT_STATIC, GET_STATIC, PUT_INSTANCE, GET_INSTANCE, INVOKE_STATIC, INVOKE_INSTANCE, INVOKE_CONSTRUCTOR};
        }
    }
}

