/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.dx.rop.type;

import com.android.jack.dx.dex.file.ValueEncoder;
import com.android.jack.dx.rop.cst.Constant;
import com.android.jack.dx.rop.cst.CstString;
import com.android.jack.dx.rop.cst.TypedConstant;
import com.android.jack.dx.rop.type.TypeBearer;
import com.android.jack.dx.util.Hex;
import java.util.HashMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class Type
extends TypedConstant
implements TypeBearer {
    private static final HashMap<String, Type> internTable = new HashMap(500);
    public static final int BT_VOID = 0;
    public static final int BT_BOOLEAN = 1;
    public static final int BT_BYTE = 2;
    public static final int BT_CHAR = 3;
    public static final int BT_DOUBLE = 4;
    public static final int BT_FLOAT = 5;
    public static final int BT_INT = 6;
    public static final int BT_LONG = 7;
    public static final int BT_SHORT = 8;
    public static final int BT_OBJECT = 9;
    public static final int BT_ADDR = 10;
    public static final int BT_COUNT = 11;
    public static final Type BOOLEAN = new Type("Z", 1);
    public static final Type BYTE = new Type("B", 2);
    public static final Type CHAR = new Type("C", 3);
    public static final Type DOUBLE = new Type("D", 4);
    public static final Type FLOAT = new Type("F", 5);
    public static final Type INT = new Type("I", 6);
    public static final Type LONG = new Type("J", 7);
    public static final Type SHORT = new Type("S", 8);
    public static final Type VOID = new Type("V", 0);
    public static final Type KNOWN_NULL = new Type("<null>", 9);
    public static final Type RETURN_ADDRESS = new Type("<addr>", 10);
    public static final Type ANNOTATION;
    public static final Type CLASS;
    public static final Type CLONEABLE;
    public static final Type OBJECT;
    public static final Type SERIALIZABLE;
    public static final Type STRING;
    public static final Type THROWABLE;
    public static final Type BOOLEAN_CLASS;
    public static final Type BYTE_CLASS;
    public static final Type CHARACTER_CLASS;
    public static final Type DOUBLE_CLASS;
    public static final Type FLOAT_CLASS;
    public static final Type INTEGER_CLASS;
    public static final Type LONG_CLASS;
    public static final Type SHORT_CLASS;
    public static final Type VOID_CLASS;
    public static final Type BOOLEAN_ARRAY;
    public static final Type BYTE_ARRAY;
    public static final Type CHAR_ARRAY;
    public static final Type DOUBLE_ARRAY;
    public static final Type FLOAT_ARRAY;
    public static final Type INT_ARRAY;
    public static final Type LONG_ARRAY;
    public static final Type OBJECT_ARRAY;
    public static final Type SHORT_ARRAY;
    private final CstString descriptor;
    private final int basicType;
    private final int newAt;
    private String className;
    private Type arrayType;
    private Type componentType;
    private Type initializedType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type intern(String descriptor) {
        char firstChar;
        Type result;
        HashMap<String, Type> hashMap = internTable;
        synchronized (hashMap) {
            result = internTable.get(descriptor);
        }
        if (result != null) {
            return result;
        }
        assert (descriptor != null);
        try {
            firstChar = descriptor.charAt(0);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new IllegalArgumentException("descriptor is empty");
        }
        if (firstChar == '[') {
            result = Type.intern(descriptor.substring(1));
            return result.getArrayType();
        }
        int length = descriptor.length();
        if (firstChar != 'L' || descriptor.charAt(length - 1) != ';') {
            throw new IllegalArgumentException("bad descriptor: " + descriptor);
        }
        int limit = length - 1;
        block9: for (int i = 1; i < limit; ++i) {
            char c = descriptor.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '.': 
                case ';': 
                case '[': {
                    throw new IllegalArgumentException("bad descriptor: " + descriptor);
                }
                case '/': {
                    if (i != 1 && i != length - 1 && descriptor.charAt(i - 1) != '/') continue block9;
                    throw new IllegalArgumentException("bad descriptor: " + descriptor);
                }
            }
        }
        result = new Type(descriptor, 9);
        return Type.putIntern(result);
    }

    public static Type internReturnType(String descriptor) {
        assert (descriptor != null);
        if (descriptor.equals("V")) {
            return VOID;
        }
        return Type.intern(descriptor);
    }

    private Type(String descriptor, int basicType, int newAt) {
        assert (descriptor != null);
        if (basicType < 0 || basicType >= 11) {
            throw new IllegalArgumentException("bad basicType");
        }
        if (newAt < -1) {
            throw new IllegalArgumentException("newAt < -1");
        }
        this.descriptor = new CstString(descriptor);
        this.basicType = basicType;
        this.newAt = newAt;
        this.arrayType = null;
        this.componentType = null;
        this.initializedType = null;
    }

    private Type(String descriptor, int basicType) {
        this(descriptor, basicType, -1);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Type)) {
            return false;
        }
        return this.descriptor.equals(((Type)other).descriptor);
    }

    public int hashCode() {
        return this.descriptor.hashCode();
    }

    public String toString() {
        return this.descriptor.getString();
    }

    @Override
    public String toHuman() {
        switch (this.basicType) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "char";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "float";
            }
            case 6: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "short";
            }
            case 9: {
                break;
            }
            default: {
                return this.descriptor.getString();
            }
        }
        if (this.isArray()) {
            return this.getComponentType().toHuman() + "[]";
        }
        return this.getClassName().replace("/", ".");
    }

    @Override
    public Type getType() {
        return this;
    }

    public Type getFrameTypeImpl() {
        switch (this.basicType) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return INT;
            }
        }
        return this;
    }

    public int getBasicTypeImpl() {
        return this.basicType;
    }

    public int getBasicFrameTypeImpl() {
        switch (this.basicType) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return 6;
            }
        }
        return this.basicType;
    }

    public CstString getDescriptor() {
        return this.descriptor;
    }

    public String getClassName() {
        if (this.className == null) {
            if (!this.isReference()) {
                throw new IllegalArgumentException("not an object type: " + this.descriptor);
            }
            String descriptorStr = this.descriptor.getString();
            this.className = descriptorStr.charAt(0) == '[' ? descriptorStr : descriptorStr.substring(1, descriptorStr.length() - 1);
        }
        return this.className;
    }

    public int getCategory() {
        switch (this.basicType) {
            case 4: 
            case 7: {
                return 2;
            }
        }
        return 1;
    }

    public boolean isCategory1() {
        switch (this.basicType) {
            case 4: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isCategory2() {
        switch (this.basicType) {
            case 4: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isIntlike() {
        switch (this.basicType) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isPrimitive() {
        switch (this.basicType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public boolean isReference() {
        return this.basicType == 9;
    }

    public boolean isArray() {
        return this.descriptor.getString().charAt(0) == '[';
    }

    public boolean isArrayOrKnownNull() {
        return this.isArray() || this.equals(KNOWN_NULL);
    }

    public boolean isUninitialized() {
        return this.newAt >= 0;
    }

    public int getNewAt() {
        return this.newAt;
    }

    public Type getInitializedType() {
        if (this.initializedType == null) {
            throw new IllegalArgumentException("initialized type: " + this.descriptor);
        }
        return this.initializedType;
    }

    public Type getArrayType() {
        if (this.arrayType == null) {
            this.arrayType = Type.putIntern(new Type('[' + this.descriptor.getString(), 9));
        }
        return this.arrayType;
    }

    public Type getComponentType() {
        if (this.componentType == null) {
            String descriptorStr = this.descriptor.getString();
            if (descriptorStr.charAt(0) != '[') {
                throw new IllegalArgumentException("not an array type: " + this.descriptor);
            }
            this.componentType = Type.intern(descriptorStr.substring(1));
        }
        return this.componentType;
    }

    public Type asUninitialized(int newAt) {
        if (newAt < 0) {
            throw new IllegalArgumentException("newAt < 0");
        }
        if (!this.isReference()) {
            throw new IllegalArgumentException("not a reference type: " + this.descriptor);
        }
        if (this.isUninitialized()) {
            throw new IllegalArgumentException("already uninitialized: " + this.descriptor);
        }
        String newDesc = 'N' + Hex.u2(newAt) + this.descriptor;
        Type result = new Type(newDesc, 9, newAt);
        result.initializedType = this;
        return Type.putIntern(result);
    }

    @Nonnegative
    public int getWordCount() {
        if (this.isCategory2()) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Type putIntern(Type type) {
        HashMap<String, Type> hashMap = internTable;
        synchronized (hashMap) {
            String descriptor = type.getDescriptor().getString();
            Type already = internTable.get(descriptor);
            if (already != null) {
                return already;
            }
            internTable.put(descriptor, type);
            return type;
        }
    }

    @Override
    public String typeName() {
        return "type";
    }

    @Override
    protected int compareTo0(Constant other) {
        assert (other instanceof Type);
        return this.descriptor.compareTo(((Type)other).descriptor);
    }

    @Override
    @Nonnull
    public ValueEncoder.ValueType getEncodedValueType() {
        return ValueEncoder.ValueType.VALUE_TYPE;
    }

    public String getPackageName() {
        String descriptor = this.getDescriptor().getString();
        int lastSlash = descriptor.lastIndexOf(47);
        int lastLeftSquare = descriptor.lastIndexOf(91);
        if (lastSlash == -1) {
            return "default";
        }
        return descriptor.substring(lastLeftSquare + 2, lastSlash).replace('/', '.');
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    static {
        Type.putIntern(BOOLEAN);
        Type.putIntern(BYTE);
        Type.putIntern(CHAR);
        Type.putIntern(DOUBLE);
        Type.putIntern(FLOAT);
        Type.putIntern(INT);
        Type.putIntern(LONG);
        Type.putIntern(SHORT);
        ANNOTATION = Type.intern("Ljava/lang/annotation/Annotation;");
        CLASS = Type.intern("Ljava/lang/Class;");
        CLONEABLE = Type.intern("Ljava/lang/Cloneable;");
        OBJECT = Type.intern("Ljava/lang/Object;");
        SERIALIZABLE = Type.intern("Ljava/io/Serializable;");
        STRING = Type.intern("Ljava/lang/String;");
        THROWABLE = Type.intern("Ljava/lang/Throwable;");
        BOOLEAN_CLASS = Type.intern("Ljava/lang/Boolean;");
        BYTE_CLASS = Type.intern("Ljava/lang/Byte;");
        CHARACTER_CLASS = Type.intern("Ljava/lang/Character;");
        DOUBLE_CLASS = Type.intern("Ljava/lang/Double;");
        FLOAT_CLASS = Type.intern("Ljava/lang/Float;");
        INTEGER_CLASS = Type.intern("Ljava/lang/Integer;");
        LONG_CLASS = Type.intern("Ljava/lang/Long;");
        SHORT_CLASS = Type.intern("Ljava/lang/Short;");
        VOID_CLASS = Type.intern("Ljava/lang/Void;");
        BOOLEAN_ARRAY = BOOLEAN.getArrayType();
        BYTE_ARRAY = BYTE.getArrayType();
        CHAR_ARRAY = CHAR.getArrayType();
        DOUBLE_ARRAY = DOUBLE.getArrayType();
        FLOAT_ARRAY = FLOAT.getArrayType();
        INT_ARRAY = INT.getArrayType();
        LONG_ARRAY = LONG.getArrayType();
        OBJECT_ARRAY = OBJECT.getArrayType();
        SHORT_ARRAY = SHORT.getArrayType();
    }
}

