/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.freemarker.core;

import com.android.jack.freemarker.core.BuiltInForString;
import com.android.jack.freemarker.core.Environment;
import com.android.jack.freemarker.core.Expression;
import com.android.jack.freemarker.core.FMParser;
import com.android.jack.freemarker.core.FMParserTokenManager;
import com.android.jack.freemarker.core.NonNumericalException;
import com.android.jack.freemarker.core.OutputFormatBoundBuiltIn;
import com.android.jack.freemarker.core.ParseException;
import com.android.jack.freemarker.core.ParserConfiguration;
import com.android.jack.freemarker.core.SimpleCharStream;
import com.android.jack.freemarker.core.TokenMgrError;
import com.android.jack.freemarker.core._DelayedGetMessage;
import com.android.jack.freemarker.core._DelayedGetMessageWithoutStackTop;
import com.android.jack.freemarker.core._DelayedJQuote;
import com.android.jack.freemarker.core._MiscTemplateException;
import com.android.jack.freemarker.core._ParserConfigurationWithInheritedFormat;
import com.android.jack.freemarker.template.SimpleNumber;
import com.android.jack.freemarker.template.Template;
import com.android.jack.freemarker.template.TemplateBooleanModel;
import com.android.jack.freemarker.template.TemplateException;
import com.android.jack.freemarker.template.TemplateModel;
import java.io.StringReader;

class BuiltInsForStringsMisc {
    private BuiltInsForStringsMisc() {
    }

    static class numberBI
    extends BuiltInForString {
        numberBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            try {
                return new SimpleNumber(env.getArithmeticEngine().toNumber(s));
            }
            catch (NumberFormatException nfe) {
                throw NonNumericalException.newMalformedNumberException(this, s, env);
            }
        }
    }

    static class evalBI
    extends OutputFormatBoundBuiltIn {
        evalBI() {
        }

        protected TemplateModel calculateResult(Environment env) throws TemplateException {
            return this.calculateResult(BuiltInForString.getTargetString(this.target, env), env);
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            Template parentTemplate = this.getTemplate();
            Expression exp = null;
            try {
                try {
                    ParserConfiguration pCfg = parentTemplate.getParserConfiguration();
                    SimpleCharStream simpleCharStream = new SimpleCharStream(new StringReader("(" + s + ")"), -1000000000, 1, s.length() + 2);
                    simpleCharStream.setTabSize(pCfg.getTabSize());
                    FMParserTokenManager tkMan = new FMParserTokenManager(simpleCharStream);
                    tkMan.SwitchTo(2);
                    if (pCfg.getOutputFormat() != this.outputFormat) {
                        pCfg = new _ParserConfigurationWithInheritedFormat(pCfg, this.outputFormat, this.autoEscapingPolicy);
                    }
                    FMParser parser = new FMParser(parentTemplate, false, tkMan, pCfg);
                    exp = parser.Expression();
                }
                catch (TokenMgrError e) {
                    throw e.toParseException(parentTemplate);
                }
            }
            catch (ParseException e) {
                throw new _MiscTemplateException((Expression)this, env, "Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessage(e), "\n---end-message---", "\n\nThe failing expression:");
            }
            try {
                return exp.eval(env);
            }
            catch (TemplateException e) {
                throw new _MiscTemplateException((Expression)this, env, "Failed to \"?", this.key, "\" string with this error:\n\n", "---begin-message---\n", new _DelayedGetMessageWithoutStackTop(e), "\n---end-message---", "\n\nThe failing expression:");
            }
        }
    }

    static class booleanBI
    extends BuiltInForString {
        booleanBI() {
        }

        TemplateModel calculateResult(String s, Environment env) throws TemplateException {
            boolean b;
            if (s.equals("true")) {
                b = true;
            } else if (s.equals("false")) {
                b = false;
            } else if (s.equals(env.getTrueStringValue())) {
                b = true;
            } else if (s.equals(env.getFalseStringValue())) {
                b = false;
            } else {
                throw new _MiscTemplateException((Expression)this, env, "Can't convert this string to boolean: ", new _DelayedJQuote(s));
            }
            return b ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE;
        }
    }
}

