/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend.java;

import com.android.jack.Jack;
import com.android.jack.eclipse.jdt.core.compiler.CategorizedProblem;
import com.android.jack.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import com.android.jack.ir.HasSourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.ir.sourceinfo.SourceInfoFactory;
import com.android.jack.reporting.Reportable;
import javax.annotation.Nonnull;

public class EcjProblem
implements Reportable,
HasSourceInfo {
    private static final int isClassPathCorrectId = 0x1000144;
    @Nonnull
    private final CategorizedProblem problem;
    @Nonnull
    private final SourceInfo sourceInfo;

    public EcjProblem(@Nonnull CategorizedProblem problem) {
        this.problem = problem;
        if (problem.getOriginatingFileName() == null) {
            this.sourceInfo = SourceInfo.UNKNOWN;
        } else {
            int lineProblem = problem.getSourceLineNumber();
            SourceInfoFactory sourceInfoFactory = Jack.getSession().getSourceInfoFactory();
            if (problem instanceof DefaultProblem) {
                int columnProblem = ((DefaultProblem)problem).getSourceColumnNumber();
                this.sourceInfo = sourceInfoFactory.create(columnProblem, 0, lineProblem, 0, String.valueOf(problem.getOriginatingFileName()));
            } else {
                this.sourceInfo = sourceInfoFactory.create(lineProblem, 0, String.valueOf(problem.getOriginatingFileName()));
            }
        }
    }

    @Nonnull
    public CategorizedProblem getProblem() {
        return this.problem;
    }

    @Override
    @Nonnull
    public SourceInfo getSourceInfo() {
        return this.sourceInfo;
    }

    @Override
    @Nonnull
    public Reportable.ProblemLevel getDefaultProblemLevel() {
        return this.problem.isError() ? Reportable.ProblemLevel.ERROR : Reportable.ProblemLevel.WARNING;
    }

    @Override
    @Nonnull
    public String getMessage() {
        String message = null;
        if (this.problem.getID() == 0x1000144) {
            assert (this.problem.getArguments().length == 1);
            message = "The type " + this.problem.getArguments()[0] + " cannot be found in source files, imported jack libs or the classpath";
        } else {
            message = this.problem.getMessage();
        }
        return message;
    }
}

