/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.frontend.java;

import com.android.jack.JackUserException;
import com.android.jack.Options;
import com.android.jack.ecj.loader.jast.JAstClasspath;
import com.android.jack.eclipse.jdt.core.compiler.CategorizedProblem;
import com.android.jack.eclipse.jdt.core.compiler.CompilationProgress;
import com.android.jack.eclipse.jdt.internal.compiler.apt.dispatch.BatchAnnotationProcessorManager;
import com.android.jack.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import com.android.jack.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import com.android.jack.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import com.android.jack.eclipse.jdt.internal.compiler.batch.ClasspathSourceJar;
import com.android.jack.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import com.android.jack.eclipse.jdt.internal.compiler.batch.FileSystem;
import com.android.jack.eclipse.jdt.internal.compiler.batch.Main;
import com.android.jack.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import com.android.jack.frontend.java.EcjLogger;
import com.android.jack.frontend.java.JAstBuilder;
import com.android.jack.google.common.base.Joiner;
import com.android.jack.ir.ast.JSession;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.JarLibrary;
import com.android.jack.reporting.Reporter;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.scheduler.SingleScheduleInstance;
import com.android.sched.util.config.Config;
import com.android.sched.util.config.ReflectFactory;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.file.FileOrDirectory;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.location.FileLocation;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class JackBatchCompiler
extends Main {
    @Nonnull
    private final JSession session;

    public JackBatchCompiler(@Nonnull JSession session) {
        super(new PrintWriter(System.out), new PrintWriter(System.err), false, null, null);
        this.session = session;
    }

    @Nonnull
    Reporter getReporter() {
        return this.session.getReporter();
    }

    @Override
    protected void addNewEntry(ArrayList paths, String currentClasspathName, ArrayList currentRuleSpecs, String customEncoding, String destPath, boolean isSourceOnly, boolean rejectDestinationPathOnJars) {
        if (isSourceOnly) {
            super.addNewEntry(paths, currentClasspathName, currentRuleSpecs, customEncoding, destPath, isSourceOnly, rejectDestinationPathOnJars);
        } else {
            ArrayList tmpPaths = new ArrayList(1);
            super.addNewEntry(tmpPaths, currentClasspathName, currentRuleSpecs, customEncoding, destPath, isSourceOnly, rejectDestinationPathOnJars);
            if (tmpPaths.size() == 1) {
                ClasspathLocation path = (ClasspathLocation)tmpPaths.get(0);
                assert (!(path instanceof ClasspathSourceJar));
                if (path instanceof ClasspathDirectory) {
                    this.session.getUserLogger().log(Level.WARNING, "Invalid entry in classpath or bootclasspath: directories are not supported: \"{0}\"", currentClasspathName);
                } else {
                    assert (path instanceof ClasspathJar);
                    File pathFile = new File(currentClasspathName);
                    if (pathFile.exists()) {
                        this.session.getUserLogger().log(Level.WARNING, "Invalid entry in classpath or bootclasspath: ''{0}''", currentClasspathName);
                    } else {
                        this.session.getUserLogger().log(Level.WARNING, "Invalid entry in classpath or bootclasspath: missing file ''{0}''", currentClasspathName);
                    }
                }
            }
        }
    }

    @Override
    public boolean compile(String[] argv) {
        return super.compile(argv);
    }

    @Override
    public void performCompilation() throws TransportJUEAroundEcjError, TransportExceptionAroundEcjError {
        this.startTime = System.currentTimeMillis();
        this.compilerOptions = new CompilerOptions(this.options);
        this.compilerOptions.performMethodsFullRecovery = false;
        this.compilerOptions.performStatementsRecovery = false;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        this.compilerOptions.verbose = this.verbose;
        FileSystem environment = this.getLibraryAccess();
        this.batchCompiler = new JAstBuilder(environment, this.getHandlingPolicy(), this.compilerOptions, this.getBatchRequestor(), this.getProblemFactory(), this.out, this.progress, this.session);
        this.batchCompiler.remainingIterations = this.maxRepetition - this.currentRepetition;
        this.batchCompiler.useSingleThread = ((ReflectFactory)((Object)ThreadConfig.get(ScheduleInstance.DEFAULT_RUNNER))).getInstanciatedClass().isAssignableFrom(SingleScheduleInstance.class);
        if (this.compilerOptions.processAnnotations) {
            this.initializeAnnotationProcessorManager();
        }
        this.logger.startLoggingSources();
        try {
            this.batchCompiler.compile(this.getCompilationUnits());
            ((JAstBuilder)this.batchCompiler).finishCompilation();
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
        catch (TransportJUEAroundEcjError e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new TransportExceptionAroundEcjError(e);
        }
        finally {
            this.logger.endLoggingSources();
            environment.cleanup();
        }
        if (this.extraProblems != null) {
            this.loggingExtraProblems();
            this.extraProblems = null;
        }
        this.logger.printStats();
    }

    @CheckForNull
    public List<CategorizedProblem> getExtraProblems() {
        return this.extraProblems;
    }

    @Override
    public void configure(String[] argv) {
        super.configure(argv);
        List sourcePath = (List)((Object)ThreadConfig.get(Options.SOURCE_PATH));
        int nbSourcePathElement = sourcePath.size();
        this.checkedClasspaths = new FileSystem.Classpath[nbSourcePathElement + 1];
        for (int i = 0; i < nbSourcePathElement; ++i) {
            this.checkedClasspaths[i] = FileSystem.getClasspath(((FileOrDirectory)sourcePath.get(i)).getPath(), null, true, null, "none", null);
        }
        this.checkedClasspaths[nbSourcePathElement] = new JAstClasspath("<jack-logical-entry>", this.session.getLookup(), null);
    }

    protected void initialize(PrintWriter outWriter, PrintWriter errWriter, boolean systemExit, Map customDefaultOptions, CompilationProgress compilationProgress) {
        super.initialize(outWriter, errWriter, systemExit, customDefaultOptions, compilationProgress);
        this.logger = new EcjLogger(this, outWriter, errWriter, this);
    }

    @Override
    public CompilationUnit[] getCompilationUnits() {
        CompilationUnit[] cu = new CompilationUnit[this.filenames.length];
        int idx = 0;
        for (String fileName : this.filenames) {
            assert (JackBatchCompiler.checkFileAccess(fileName));
            cu[idx] = new CompilationUnit(null, fileName, this.encodings[idx]);
            ++idx;
        }
        return cu;
    }

    @Override
    protected void initializeAnnotationProcessorManager() {
        ArrayList<String> processorArgs = new ArrayList<String>();
        Config config = ThreadConfig.getConfig();
        for (Map.Entry<String, String> entry : config.get(Options.ANNOTATION_PROCESSOR_OPTIONS).entrySet()) {
            processorArgs.add("-A" + entry.getKey() + "=" + entry.getValue());
        }
        if (config.get(Options.ANNOTATION_PROCESSOR_MANUAL).booleanValue()) {
            processorArgs.add("-processor");
            processorArgs.add(Joiner.on(',').join((Iterable)((Object)config.get(Options.ANNOTATION_PROCESSOR_MANUAL_LIST))));
        }
        if (config.get(Options.ANNOTATION_PROCESSOR_PATH).booleanValue()) {
            processorArgs.add("-processorpath");
            processorArgs.add(JackBatchCompiler.getPathString((List)((Object)config.get(Options.ANNOTATION_PROCESSOR_PATH_LIST))));
        }
        processorArgs.add("-s");
        processorArgs.add(config.get(Options.ANNOTATION_PROCESSOR_SOURCE_OUTPUT_DIR).getPath());
        processorArgs.add("-d");
        processorArgs.add(config.get(Options.ANNOTATION_PROCESSOR_CLASS_OUTPUT_DIR).getPath());
        List<InputLibrary> classpath = config.get(Options.CLASSPATH);
        ArrayList<String> jarOnlyClasspath = new ArrayList<String>();
        for (InputLibrary classpathEntry : classpath) {
            if (!(classpathEntry instanceof JarLibrary)) continue;
            jarOnlyClasspath.add(classpathEntry.getPath());
        }
        if (!jarOnlyClasspath.isEmpty()) {
            processorArgs.add("-classpath");
            processorArgs.add(Joiner.on(File.pathSeparatorChar).join(jarOnlyClasspath));
        }
        String[] args = processorArgs.toArray(new String[processorArgs.size()]);
        BatchAnnotationProcessorManager manager = new BatchAnnotationProcessorManager();
        manager.configure(this, args);
        manager.setOut(this.out);
        this.batchCompiler.annotationProcessorManager = manager;
    }

    @Nonnull
    private static String getPathString(@Nonnull List<FileOrDirectory> pathList) {
        StringBuilder path = new StringBuilder();
        Iterator<FileOrDirectory> iter = pathList.iterator();
        while (iter.hasNext()) {
            path.append(iter.next().getPath());
            if (!iter.hasNext()) continue;
            path.append(File.pathSeparatorChar);
        }
        return path.toString();
    }

    private static boolean checkFileAccess(@Nonnull String fileName) {
        try {
            File file = new File(fileName);
            FileOrDirectory.checkPermissions(file, new FileLocation(fileName), 1);
        }
        catch (WrongPermissionException e) {
            return false;
        }
        return true;
    }

    public static class TransportJUEAroundEcjError
    extends Error {
        private static final long serialVersionUID = 1L;

        public TransportJUEAroundEcjError(@Nonnull JackUserException cause) {
            super(cause);
        }

        @Override
        @Nonnull
        public JackUserException getCause() {
            return (JackUserException)super.getCause();
        }
    }

    public static class TransportExceptionAroundEcjError
    extends Error {
        private static final long serialVersionUID = 1L;

        public TransportExceptionAroundEcjError(@Nonnull RuntimeException cause) {
            super(cause);
        }

        @Override
        @Nonnull
        public RuntimeException getCause() {
            return (RuntimeException)super.getCause();
        }
    }
}

