/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java assert statement")
public class JAssertStatement
extends JStatement {
    @CheckForNull
    private JExpression arg;
    @Nonnull
    private JExpression testExpr;

    public JAssertStatement(@Nonnull SourceInfo info, @Nonnull JExpression testExpr, @CheckForNull JExpression arg) {
        super(info);
        this.testExpr = testExpr;
        this.arg = arg;
    }

    @CheckForNull
    public JExpression getArg() {
        return this.arg;
    }

    @Nonnull
    public JExpression getTestExpr() {
        return this.testExpr;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.testExpr);
            if (this.arg != null) {
                visitor.accept(this.arg);
            }
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.testExpr.traverse(schedule);
        if (this.arg != null) {
            this.arg.traverse(schedule);
        }
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.testExpr == existingNode) {
            this.testExpr = (JExpression)newNode;
        } else if (this.arg == existingNode) {
            this.arg = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    protected void removeImpl(@Nonnull JNode existingNode) throws UnsupportedOperationException {
        if (this.arg == existingNode) {
            this.arg = null;
        } else {
            super.removeImpl(existingNode);
        }
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }
}

