/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JInterface;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdRef;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.item.Tag;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@Description(value="Lambda expression")
public class JLambda
extends JExpression {
    @Nonnull
    private JMethodId mthIdWithErasure;
    @Nonnull
    private final JMethodId mthIdWithoutErasure;
    @Nonnull
    private final JInterface type;
    @Nonnull
    private final List<JInterface> interfaceBounds;
    @Nonnull
    private final List<JExpression> capturedVariables = new ArrayList<JExpression>(0);
    @Nonnull
    private final JMethodIdRef methodIdRef;
    @Nonnull
    private final List<JMethodId> bridges = new ArrayList<JMethodId>();

    public JLambda(@Nonnull SourceInfo info, @Nonnull JMethodId mthIdWithErasure, @Nonnull JMethodIdRef methodRef, @Nonnull JInterface type, @Nonnull List<JInterface> interfaceBounds, @Nonnull JMethodId mthIdWithoutErasure) {
        super(info);
        assert (methodRef != null);
        assert (type != null);
        this.mthIdWithErasure = mthIdWithErasure;
        this.type = type;
        this.methodIdRef = methodRef;
        this.interfaceBounds = interfaceBounds;
        this.mthIdWithoutErasure = mthIdWithoutErasure;
    }

    @Nonnull
    public JMethodId getMethodIdWithErasure() {
        return this.mthIdWithErasure;
    }

    @Nonnull
    public JMethodId getMethodIdWithoutErasure() {
        return this.mthIdWithoutErasure;
    }

    @Nonnull
    public List<JMethodId> getBridgeMethodIds() {
        return this.bridges;
    }

    public void addBridgeMethodId(@Nonnull JMethodId bridgeMethodId) {
        this.bridges.add(bridgeMethodId);
    }

    public void addBridgeMethodIds(@Nonnull List<JMethodId> bridgeMethodIds) {
        this.bridges.addAll(bridgeMethodIds);
    }

    public void addCapturedVariable(@Nonnull JExpression capturedVariable) {
        this.capturedVariables.add(capturedVariable);
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        visitor.visit(this);
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
    }

    @Override
    public void visit(JVisitor visitor, TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Override
    @Nonnull
    public JInterface getType() {
        return this.type;
    }

    @Nonnull
    public JMethodIdRef getMethodIdRef() {
        return this.methodIdRef;
    }

    @Nonnull
    public List<JExpression> getCapturedVariables() {
        return this.capturedVariables;
    }

    @Override
    public boolean canThrow() {
        return true;
    }

    @Nonnull
    public List<JInterface> getInterfaceBounds() {
        return this.interfaceBounds;
    }

    public void resolveMethodId(@Nonnull JMethodId methodId) {
        this.mthIdWithErasure = methodId;
    }

    @Description(value="Default bridges were added into JLambda when they are needed.")
    public static final class DefaultBridgeAddedInLambda
    implements Tag {
    }
}

