/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JAbstractMethodCall;
import com.android.jack.ir.ast.JClassOrInterface;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JPolymorphicMethodCall;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java method call expression")
public class JMethodCall
extends JAbstractMethodCall {
    @Nonnull
    private final DispatchKind dispatchKind;

    public JMethodCall(@Nonnull JMethodCall other, @CheckForNull JExpression instance) {
        super(other.getSourceInfo(), instance, other.getReceiverType(), other.getMethodId());
        this.dispatchKind = other.getDispatchKind();
        assert (other.getReceiverType() == null || !JPolymorphicMethodCall.isCallToPolymorphicMethod(other.getReceiverType(), other.getMethodId()));
    }

    public JMethodCall(@Nonnull SourceInfo info, @CheckForNull JExpression instance, @Nonnull JClassOrInterface receiverType, @Nonnull JMethodId methodId, boolean isVirtualDispatch) {
        super(info, instance, receiverType, methodId);
        assert (methodId != null);
        assert (receiverType == null || !JPolymorphicMethodCall.isCallToPolymorphicMethod(receiverType, methodId));
        assert (!isVirtualDispatch || this.getMethodIdWide().getKind() == MethodKind.INSTANCE_VIRTUAL);
        this.dispatchKind = isVirtualDispatch ? DispatchKind.VIRTUAL : DispatchKind.DIRECT;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.visitChildren(schedule);
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Nonnull
    public DispatchKind getDispatchKind() {
        return this.dispatchKind;
    }

    @Override
    public boolean isCallToPolymorphicMethod() {
        return JMethodCall.isCallToPolymorphicMethod(this.getReceiverType(), this.getMethodId());
    }

    public static enum DispatchKind {
        VIRTUAL,
        DIRECT;

    }
}

