/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.ir.ast.JBlock;
import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JStatement;
import com.android.jack.ir.ast.JVisitor;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.sched.item.Component;
import com.android.sched.item.Description;
import com.android.sched.item.Tag;
import com.android.sched.scheduler.ScheduleInstance;
import com.android.sched.transform.TransformRequest;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Java switch statement")
public class JSwitchStatement
extends JStatement {
    @Nonnull
    private final JBlock body;
    @Nonnull
    private JExpression expr;
    @Nonnull
    private final List<JCaseStatement> cases;
    @CheckForNull
    private JCaseStatement defaultCase;

    public JSwitchStatement(@Nonnull SourceInfo info, @Nonnull JExpression expr, @Nonnull JBlock body, @Nonnull List<JCaseStatement> cases, @CheckForNull JCaseStatement defaultCase) {
        super(info);
        this.expr = expr;
        this.body = body;
        this.cases = cases;
        this.defaultCase = defaultCase;
    }

    @Nonnull
    public JBlock getBody() {
        return this.body;
    }

    @Nonnull
    public JExpression getExpr() {
        return this.expr;
    }

    @CheckForNull
    public JCaseStatement getDefaultCase() {
        return this.defaultCase;
    }

    public void addCase(@Nonnull JCaseStatement caseStatement) {
        this.cases.add(caseStatement);
    }

    public void removeCase(@Nonnull JCaseStatement caseStatement) {
        this.cases.remove(caseStatement);
    }

    @Nonnull
    public List<JCaseStatement> getCases() {
        return this.cases;
    }

    public void setDefaultCase(@CheckForNull JCaseStatement defaultCase) {
        this.defaultCase = defaultCase;
    }

    @Override
    public void traverse(@Nonnull JVisitor visitor) {
        if (visitor.visit(this)) {
            visitor.accept(this.expr);
            visitor.accept(this.body);
        }
        visitor.endVisit(this);
    }

    @Override
    public void traverse(@Nonnull ScheduleInstance<? super Component> schedule) throws Exception {
        schedule.process(this);
        this.expr.traverse(schedule);
        this.body.traverse(schedule);
    }

    @Override
    protected void replaceImpl(@Nonnull JNode existingNode, @Nonnull JNode newNode) throws UnsupportedOperationException {
        assert (newNode != null);
        if (this.expr == existingNode) {
            this.expr = (JExpression)newNode;
        } else {
            super.replaceImpl(existingNode, newNode);
        }
    }

    @Override
    public void visit(@Nonnull JVisitor visitor, @Nonnull TransformRequest transformRequest) throws Exception {
        visitor.visit(this, transformRequest);
    }

    @Description(value="A JSwitchStatement may use string.")
    public static final class SwitchWithString
    implements Tag {
    }

    @Description(value="A JSwitchStatement may use enum values directly.")
    public static final class SwitchWithEnum
    implements Tag {
    }
}

