/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.ast;

import com.android.jack.Jack;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.Annotable;
import com.android.jack.ir.ast.CanBeRenamed;
import com.android.jack.ir.ast.CanBeSetFinal;
import com.android.jack.ir.ast.HasName;
import com.android.jack.ir.ast.HasType;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JNode;
import com.android.jack.ir.ast.JPrimitiveType;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JVariableRef;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.util.AnnotationUtils;
import com.android.sched.item.Description;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@Description(value="Any storage location")
public abstract class JVariable
extends JNode
implements HasName,
CanBeSetFinal,
CanBeRenamed,
HasType,
Annotable {
    @CheckForNull
    private String name;
    @Nonnull
    private final JType type;
    @Nonnull
    protected final List<JAnnotation> annotations = new ArrayList<JAnnotation>();
    protected int modifier;

    JVariable(SourceInfo info, @CheckForNull String name, @Nonnull JType type, int modifier) {
        super(info);
        assert (type != null);
        assert (type != JPrimitiveType.JPrimitiveTypeEnum.VOID.getType());
        this.name = name == null ? null : StringInterner.get().intern(name);
        this.type = type;
        this.modifier = modifier;
    }

    JVariable(SourceInfo info, @Nonnull JType type, int modifier) {
        this(info, null, type, modifier);
    }

    public int getModifier() {
        return this.modifier;
    }

    @Override
    @CheckForNull
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(@CheckForNull String name) {
        this.name = name == null ? null : StringInterner.get().intern(name);
    }

    @Override
    @Nonnull
    public JType getType() {
        return this.type;
    }

    @Override
    public boolean isFinal() {
        return JModifier.isFinal(this.modifier);
    }

    public boolean isSynthetic() {
        return JModifier.isSynthetic(this.modifier);
    }

    public boolean isCapturedVariable() {
        return JModifier.isCapturedVariable(this.modifier);
    }

    @Override
    public void setFinal() {
        this.modifier |= 0x10;
    }

    public void setSynthetic() {
        this.modifier |= 0x1000;
    }

    public void setCapturedVariable() {
        this.modifier |= 0x80000;
    }

    public void setModifier(int modifier) {
        this.modifier = modifier;
    }

    @Override
    public void addAnnotation(@Nonnull JAnnotation annotation) {
        this.annotations.add(annotation);
    }

    @Nonnull
    public List<JAnnotation> getAnnotations(@Nonnull JAnnotationType annotationType) {
        return Jack.getUnmodifiableCollections().getUnmodifiableList(AnnotationUtils.getAnnotation(this.annotations, annotationType));
    }

    @Override
    @Nonnull
    public Collection<JAnnotation> getAnnotations() {
        return Jack.getUnmodifiableCollections().getUnmodifiableCollection(this.annotations);
    }

    @Override
    @Nonnull
    public Set<JAnnotationType> getAnnotationTypes() {
        return Jack.getUnmodifiableCollections().getUnmodifiableSet(AnnotationUtils.getAnnotationTypes(this.annotations));
    }

    @Override
    protected void transform(@Nonnull JNode existingNode, @CheckForNull JNode newNode, @Nonnull JNode.Transformation transformation) throws UnsupportedOperationException {
        if (!JVariable.transform(this.annotations, existingNode, (JAnnotation)newNode, transformation)) {
            super.transform(existingNode, newNode, transformation);
        }
    }

    @Nonnull
    public abstract JVariableRef makeRef(@Nonnull SourceInfo var1);
}

