/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.ir.impl;

import com.android.jack.Jack;
import com.android.jack.eclipse.jdt.core.compiler.CharOperation;
import com.android.jack.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import com.android.jack.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import com.android.jack.ir.StringInterner;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClass;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JDefinedEnum;
import com.android.jack.ir.ast.JDefinedInterface;
import com.android.jack.ir.ast.JModifier;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.marker.GenericSignature;
import com.android.jack.ir.ast.marker.SimpleName;
import com.android.jack.ir.impl.CudInfo;
import com.android.jack.ir.impl.JackIrBuilder;
import com.android.jack.ir.impl.ReferenceMapper;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.load.ClassOrInterfaceLoader;
import com.android.jack.lookup.JPhantomLookup;
import com.android.jack.util.NamingTools;
import com.android.sched.marker.Marker;
import com.android.sched.util.location.Location;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class EcjSourceTypeLoader
implements ClassOrInterfaceLoader {
    @Nonnull
    private final WeakReference<SourceTypeBinding> bindingRef;
    @CheckForNull
    private final WeakReference<TypeDeclaration> declarationRef;
    @Nonnull
    private final WeakReference<ReferenceMapper> refMap;
    private int loadStatus = 0;
    @Nonnull
    private final Location location;

    @Nonnull
    public static JDefinedClassOrInterface createType(@Nonnull ReferenceMapper refMap, @Nonnull JPackage enclosingPackage, @Nonnull SourceTypeBinding binding, @CheckForNull TypeDeclaration typeDeclaration, Location location) {
        JDefinedClassOrInterface type;
        EcjSourceTypeLoader loader = new EcjSourceTypeLoader(refMap, binding, typeDeclaration, location);
        CudInfo cuInfo = new CudInfo(binding.scope.referenceCompilationUnit());
        SourceInfo info = ReferenceMapper.makeSourceInfo(cuInfo, binding.scope.referenceContext, refMap.getSourceInfoFactory());
        String name = binding instanceof LocalTypeBinding ? NamingTools.getSimpleClassNameFromBinaryName(new String(binding.constantPoolName())) : new String(binding.compoundName[binding.compoundName.length - 1]);
        name = EcjSourceTypeLoader.intern(name);
        assert (!EcjSourceTypeLoader.typeAlreadyCreated(enclosingPackage, name));
        int accessFlags = binding.getAccessFlags();
        if (binding.isClass()) {
            type = new JDefinedClass(info, name, accessFlags, enclosingPackage, loader);
        } else if (binding.isInterface()) {
            if (binding.isAnnotationType()) {
                assert (JModifier.isAnnotation(accessFlags));
                type = new JDefinedAnnotationType(info, name, accessFlags, enclosingPackage, loader);
            } else {
                type = new JDefinedInterface(info, name, accessFlags, enclosingPackage, loader);
            }
        } else if (binding.isEnum()) {
            if (binding.isAnonymousType()) {
                assert (JModifier.isEnum(accessFlags));
                type = new JDefinedClass(info, name, accessFlags, enclosingPackage, loader);
            } else {
                type = new JDefinedEnum(info, name, accessFlags, enclosingPackage, loader);
            }
        } else {
            throw new AssertionError((Object)"ReferenceBinding is not a class, interface, or enum.");
        }
        return type;
    }

    private static boolean typeAlreadyCreated(@Nonnull JPackage enclosingPackage, @Nonnull String name) {
        for (JDefinedClassOrInterface jDefinedClassOrInterface : enclosingPackage.getLoadedTypes()) {
            if (!jDefinedClassOrInterface.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private EcjSourceTypeLoader(@Nonnull ReferenceMapper refMap, @Nonnull SourceTypeBinding binding, @CheckForNull TypeDeclaration typeDeclaration, @Nonnull Location location) {
        this.refMap = new WeakReference<ReferenceMapper>(refMap);
        this.bindingRef = new WeakReference<SourceTypeBinding>(binding);
        this.declarationRef = typeDeclaration != null ? new WeakReference<TypeDeclaration>(typeDeclaration) : null;
        this.location = location;
        if (!binding.isAnnotationType()) {
            this.loadStatus |= Scope.RETENTION.getMask();
        }
    }

    @Override
    @Nonnull
    public Location getLocation(@Nonnull JDefinedClassOrInterface loaded) {
        return this.location;
    }

    private void load(@Nonnull FieldBinding binding) {
        this.getRefMap().get(binding);
    }

    @Nonnull
    private ReferenceMapper getRefMap() {
        ReferenceMapper refMap = (ReferenceMapper)this.refMap.get();
        assert (refMap != null);
        return refMap;
    }

    private void load(@Nonnull MethodBinding binding) {
        this.getRefMap().get(binding);
    }

    @Nonnull
    private SourceTypeBinding getBinding() {
        SourceTypeBinding binding = (SourceTypeBinding)this.bindingRef.get();
        assert (binding != null);
        return binding;
    }

    @Nonnull
    private static String intern(@Nonnull String name) {
        return StringInterner.get().intern(name);
    }

    static boolean isNested(@Nonnull ReferenceBinding binding) {
        return binding.isNestedType() && !binding.isStatic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureHierarchy(@Nonnull JDefinedClassOrInterface loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            ReferenceBinding[] superInterfaces;
            ReferenceBinding superclass;
            if (this.isLoaded(Scope.HIERARCHY)) {
                return;
            }
            SourceTypeBinding binding = this.getBinding();
            JPhantomLookup lookup = Jack.getSession().getPhantomLookup();
            if (loaded instanceof JDefinedClass && (superclass = binding.superclass()) != null) {
                ((JDefinedClass)loaded).setSuperClass(lookup.getClass(new String(superclass.signature())));
            }
            if ((superInterfaces = binding.superInterfaces()) != null) {
                for (ReferenceBinding intf : superInterfaces) {
                    loaded.addImplements(lookup.getInterface(new String(intf.signature())));
                }
            }
            this.markLoaded(Scope.HIERARCHY, loaded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureEnclosing(@Nonnull JDefinedClassOrInterface loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            if (this.isLoaded(Scope.ENCLOSING)) {
                return;
            }
            ReferenceBinding enclosingBinding = this.getBinding().enclosingType();
            if (enclosingBinding != null) {
                try {
                    JDefinedClassOrInterface enclosing = (JDefinedClassOrInterface)this.getRefMap().get(enclosingBinding);
                    loaded.setEnclosingType(enclosing);
                    enclosing.addMemberType(loaded);
                }
                catch (JTypeLookupException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.markLoaded(Scope.ENCLOSING, loaded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureMarkers(@Nonnull JDefinedClassOrInterface loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            if (this.isLoaded(Scope.MARKERS)) {
                return;
            }
            SourceTypeBinding binding = this.getBinding();
            char[] genSignature = binding.genericSignature();
            if (genSignature != null && CharOperation.contains('<', genSignature)) {
                assert (CharOperation.contains('>', genSignature));
                loaded.addMarker(new GenericSignature(ReferenceMapper.intern(genSignature)));
            }
            loaded.addMarker(new SimpleName(new String(binding.sourceName)));
            this.markLoaded(Scope.MARKERS, loaded);
        }
    }

    @Override
    public void ensureMarker(@Nonnull JDefinedClassOrInterface loaded, @Nonnull Class<? extends Marker> cls) {
        if (cls == GenericSignature.class || cls == SimpleName.class) {
            this.ensureMarkers(loaded);
        }
    }

    @Override
    public void ensureAnnotations(@Nonnull JDefinedClassOrInterface loaded) {
    }

    @Override
    public void ensureAnnotation(@Nonnull JDefinedClassOrInterface loaded, @Nonnull JAnnotationType annotationType) {
        this.ensureAnnotations(loaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureInners(@Nonnull JDefinedClassOrInterface loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            if (this.isLoaded(Scope.INNERS)) {
                return;
            }
            if (this.declarationRef != null) {
                TypeDeclaration declaration = (TypeDeclaration)this.declarationRef.get();
                assert (declaration != null);
                if (declaration.memberTypes != null) {
                    ReferenceMapper referenceMapper = (ReferenceMapper)this.refMap.get();
                    for (TypeDeclaration memberType : declaration.memberTypes) {
                        try {
                            assert (!JackIrBuilder.hasError(memberType));
                            ((JDefinedClassOrInterface)referenceMapper.get(memberType.binding)).getEnclosingType();
                        }
                        catch (JTypeLookupException e) {
                            throw new AssertionError((Object)e);
                        }
                    }
                }
            }
            this.markLoaded(Scope.INNERS, loaded);
        }
    }

    public void loadFully(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureHierarchy(loaded);
        this.ensureMarkers(loaded);
        this.ensureModifier(loaded);
        this.ensureAnnotations(loaded);
        this.ensureMethods(loaded);
        this.ensureFields(loaded);
        this.ensureEnclosing(loaded);
        this.ensureInners(loaded);
        if (loaded instanceof JDefinedAnnotationType) {
            this.ensureRetentionPolicy((JDefinedAnnotationType)loaded);
        }
        assert (loaded.getLoader() != this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureMethods(@Nonnull JDefinedClassOrInterface loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            if (this.isLoaded(Scope.METHODS)) {
                return;
            }
            SourceTypeBinding binding = this.getBinding();
            for (MethodBinding methodBinding : binding.methods()) {
                this.load(methodBinding);
            }
            this.markLoaded(Scope.METHODS, loaded);
        }
    }

    @Override
    public void ensureMethod(@Nonnull JDefinedClassOrInterface loaded, @Nonnull String name, @Nonnull List<? extends JType> args, @Nonnull JType returnType) {
        this.ensureMethods(loaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureFields(@Nonnull JDefinedClassOrInterface loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            if (this.isLoaded(Scope.FIELDS)) {
                return;
            }
            SourceTypeBinding binding = this.getBinding();
            for (FieldBinding fieldBinding : binding.fields()) {
                this.load(fieldBinding);
            }
            this.markLoaded(Scope.FIELDS, loaded);
        }
    }

    @Override
    public void ensureFields(@Nonnull JDefinedClassOrInterface loaded, @Nonnull String fieldName) {
        this.ensureFields(loaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureRetentionPolicy(@Nonnull JDefinedAnnotationType loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            if (this.isLoaded(Scope.RETENTION)) {
                return;
            }
            loaded.setRetentionPolicy(ReferenceMapper.getRetentionPolicy(this.getBinding().getAnnotationTagBits()));
            this.markLoaded(Scope.RETENTION, loaded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureModifier(@Nonnull JDefinedClassOrInterface loaded) {
        EcjSourceTypeLoader ecjSourceTypeLoader = this;
        synchronized (ecjSourceTypeLoader) {
            if (this.isLoaded(Scope.MODIFIER)) {
                return;
            }
            SourceTypeBinding binding = this.getBinding();
            int accessFlags = binding.getAccessFlags();
            if (binding.isAnonymousType() && JackIrBuilder.isNested(binding)) {
                NestedTypeBinding nestedBinding = (NestedTypeBinding)binding;
                accessFlags |= 8;
                if (nestedBinding.enclosingInstances != null) {
                    accessFlags &= 0xFFFFFFF7;
                }
            }
            if (binding.isDeprecated()) {
                accessFlags |= 0x100000;
            }
            loaded.setModifier(accessFlags);
            this.markLoaded(Scope.MODIFIER, loaded);
        }
    }

    @Override
    public void ensureSourceInfo(@Nonnull JDefinedClassOrInterface loaded) {
    }

    private boolean isLoaded(@Nonnull Scope range) {
        return (this.loadStatus & range.getMask()) != 0;
    }

    private void markLoaded(@Nonnull Scope range, @Nonnull JDefinedClassOrInterface loaded) {
        this.loadStatus |= range.getMask();
        if (this.loadStatus == Scope.ALL) {
            loaded.removeLoader();
        }
    }

    private static enum Scope {
        HIERARCHY,
        FIELDS,
        METHODS,
        MARKERS,
        RETENTION,
        MODIFIER,
        ENCLOSING,
        INNERS;

        private static final int ALL;
        private final int mask = 1 << this.ordinal();

        public int getMask() {
            return this.mask;
        }

        static {
            int full = 0;
            for (Scope scope : Scope.values()) {
                full |= scope.getMask();
            }
            ALL = full;
        }
    }
}

