/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce;

import com.android.jack.Jack;
import com.android.jack.LibraryException;
import com.android.jack.frontend.ParentSetter;
import com.android.jack.google.common.cache.Cache;
import com.android.jack.google.common.cache.CacheBuilder;
import com.android.jack.google.common.eventbus.Subscribe;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JDefinedAnnotationType;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JPackage;
import com.android.jack.ir.ast.JSession;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.formatter.TypePackageAndMethodFormatter;
import com.android.jack.jayce.DeclaredTypeNode;
import com.android.jack.jayce.JayceFormatException;
import com.android.jack.jayce.JayceReaderFactory;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.library.HasInputLibrary;
import com.android.jack.library.InputJackLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.library.TypeInInputLibraryLocation;
import com.android.jack.load.ClassOrInterfaceLoader;
import com.android.jack.load.JackLoadingException;
import com.android.jack.lookup.JLookupException;
import com.android.jack.management.CleanMemoryRequest;
import com.android.jack.management.Impact;
import com.android.sched.marker.Marker;
import com.android.sched.util.config.HasKeyId;
import com.android.sched.util.config.ThreadConfig;
import com.android.sched.util.config.id.BooleanPropertyId;
import com.android.sched.util.file.WrongPermissionException;
import com.android.sched.util.findbugs.SuppressFBWarnings;
import com.android.sched.util.location.Location;
import com.android.sched.util.log.LoggerFactory;
import com.android.sched.util.log.Tracer;
import com.android.sched.util.log.TracerFactory;
import com.android.sched.util.log.stats.Counter;
import com.android.sched.util.log.stats.CounterImpl;
import com.android.sched.util.log.stats.Percent;
import com.android.sched.util.log.stats.PercentImpl;
import com.android.sched.util.log.stats.StatisticId;
import com.android.sched.vfs.InputVFile;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

@HasKeyId
public class JayceClassOrInterfaceLoader
implements ClassOrInterfaceLoader,
HasInputLibrary {
    @Nonnull
    public static final BooleanPropertyId NNODE_CACHE = BooleanPropertyId.create("jack.jayce.cache", "Use NNode cache").addDefaultValue(Boolean.TRUE);
    @Nonnull
    private static final StatisticId<Counter> NNODE_TYPE_LOAD = new StatisticId<Counter>("jack.nnode-to-jnode.type", "NDeclaredType loaded in a JNode at type level", CounterImpl.class, Counter.class);
    @Nonnull
    private static final StatisticId<Percent> NNODE_REREAD = new StatisticId<Percent>("jack.jayce-to-nnode", "Jayce file reread versus total jayce file read", PercentImpl.class, Percent.class);
    @Nonnull
    private static final StatisticId<Percent> NNODE_CACHE_HIT = new StatisticId<Percent>("jack.jayce.cache.hit", "NNode cache hit", PercentImpl.class, Percent.class);
    @Nonnull
    private static final StatisticId<Percent> NNODE_CACHE_CROSS = new StatisticId<Percent>("jack.jayce.cache.hit.cross-compilation", "NNode cache hit due to previous compilation", PercentImpl.class, Percent.class);
    @Nonnull
    private static final StatisticId<Percent> NNODE_CACHABLE = new StatisticId<Percent>("jack.jayce.cache.cachable", "NNode cache possible", PercentImpl.class, Percent.class);
    @Nonnull
    private static final StatisticId<Counter> NNODE_STRUCTURE_LOAD = new StatisticId<Counter>("jack.nnode-to-jnode.structure", "NDeclaredType loaded in a JNode at structure level", CounterImpl.class, Counter.class);
    @Nonnull
    private static Cache<NNodeId, DeclaredTypeNode> cache = CacheBuilder.newBuilder().softValues().build();
    @Nonnull
    private static final Logger logger;
    @Nonnull
    private final InputVFile source;
    @Nonnull
    private Reference<DeclaredTypeNode> nnode = new SoftReference<Object>(null);
    private boolean structureLoaded = false;
    private boolean annotationLoaded = false;
    @Nonnull
    private final JSession session;
    @Nonnull
    private final NodeLevel defaultLoadLevel;
    @Nonnegative
    private int nnodeReadCount = 0;
    @Nonnull
    private final InputJackLibrary inputJackLibrary;
    @Nonnull
    private final String simpleName;
    @Nonnull
    private final JPackage enclosingPackage;
    @Nonnull
    private final Location location;
    @Nonnull
    private final Object annotationLock = new Object();
    @Nonnull
    private final NNodeId id;
    @Nonnull
    final Tracer tracer = TracerFactory.getTracer();

    JayceClassOrInterfaceLoader(@Nonnull InputJackLibrary jackLibrary, @Nonnull JPackage enclosingPackage, @Nonnull String simpleName, @Nonnull InputVFile source, @Nonnull JSession session, @Nonnull NodeLevel defaultLoadLevel) {
        this.inputJackLibrary = jackLibrary;
        this.enclosingPackage = enclosingPackage;
        this.simpleName = simpleName;
        this.source = source;
        this.session = session;
        this.defaultLoadLevel = defaultLoadLevel;
        String fqName = Jack.getUserFriendlyFormatter().getName(enclosingPackage, simpleName);
        this.location = new TypeInInputLibraryLocation(this.inputJackLibrary, fqName);
        boolean cache = session.getConfig().get(NNODE_CACHE);
        this.id = new NNodeId(session.getConfig().getName(), cache ? this.inputJackLibrary.getDigest() : null, fqName);
    }

    @Nonnull
    public JSession getSession() {
        return this.session;
    }

    @Override
    @Nonnull
    public Location getLocation(@Nonnull JDefinedClassOrInterface loaded) {
        return this.getLocation();
    }

    @Override
    public void ensureRetentionPolicy(@Nonnull JDefinedAnnotationType loaded) {
    }

    @Override
    public void ensureModifier(@Nonnull JDefinedClassOrInterface loaded) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureAnnotations(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
        Object object = this.annotationLock;
        synchronized (object) {
            if (!this.annotationLoaded) {
                DeclaredTypeNode type;
                this.annotationLoaded = true;
                try {
                    type = this.getNNode(NodeLevel.STRUCTURE);
                }
                catch (LibraryException e) {
                    throw new JackLoadingException(this.getLocation(), e);
                }
                try {
                    type.loadAnnotations(loaded, this);
                }
                catch (JLookupException e) {
                    throw new JackLoadingException(this.getLocation(), e);
                }
                ParentSetter parentSetter = new ParentSetter();
                parentSetter.accept(loaded);
                loaded.removeLoader();
            }
        }
    }

    @Override
    public void ensureHierarchy(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
    }

    @Override
    public void ensureMarkers(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
    }

    @Override
    public void ensureMarker(@Nonnull JDefinedClassOrInterface loaded, @Nonnull Class<? extends Marker> cls) {
        this.ensureMarkers(loaded);
    }

    @Override
    public void ensureEnclosing(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
    }

    @Override
    public void ensureInners(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
    }

    @Override
    public void ensureAnnotation(@Nonnull JDefinedClassOrInterface loaded, @Nonnull JAnnotationType annotation) {
        this.ensureAnnotations(loaded);
    }

    @Override
    public void ensureMethods(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
    }

    @Override
    public void ensureMethod(@Nonnull JDefinedClassOrInterface loaded, @Nonnull String name, @Nonnull List<? extends JType> args, @Nonnull JType returnType) {
        this.ensureMethods(loaded);
    }

    @Override
    public void ensureFields(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
    }

    @Override
    public void ensureFields(@Nonnull JDefinedClassOrInterface loaded, @Nonnull String fieldName) {
        this.ensureFields(loaded);
    }

    @Override
    public void ensureSourceInfo(@Nonnull JDefinedClassOrInterface loaded) {
        this.ensureStructure(loaded);
    }

    @Nonnull
    Location getLocation() {
        return this.location;
    }

    @Nonnull
    JDefinedClassOrInterface load() throws LibraryFormatException, LibraryIOException {
        if (this.defaultLoadLevel == NodeLevel.TYPES) {
            this.tracer.getStatistic(NNODE_TYPE_LOAD).incValue();
        }
        DeclaredTypeNode type = this.getNNode(NodeLevel.TYPES);
        assert (this.checkName(type.getSignature()));
        JDefinedClassOrInterface jType = type.create(this.enclosingPackage, this);
        return jType;
    }

    @Nonnull
    DeclaredTypeNode getNNode(@Nonnull NodeLevel minimumLevel) throws LibraryFormatException, LibraryIOException {
        DeclaredTypeNode candidate;
        if (this.id.isCachable()) {
            this.tracer.getStatistic(NNODE_CACHABLE).addTrue();
            candidate = cache.getIfPresent(this.id);
            if (this.tracer.isTracing()) {
                boolean hit = candidate != null && candidate.getLevel().keep(minimumLevel);
                this.tracer.getStatistic(NNODE_CACHE_HIT).add(hit);
                if (hit) {
                    for (Map.Entry entry : cache.asMap().entrySet()) {
                        if (entry.getValue() != candidate) continue;
                        this.tracer.getStatistic(NNODE_CACHE_CROSS).add(!((NNodeId)entry.getKey()).getSessionId().equals(ThreadConfig.getConfig().getName()));
                        break;
                    }
                }
            }
        } else {
            this.tracer.getStatistic(NNODE_CACHABLE).addFalse();
            candidate = this.nnode.get();
        }
        if (candidate == null || !candidate.getLevel().keep(minimumLevel)) {
            BufferedInputStream in = null;
            try {
                in = new BufferedInputStream(this.source.getInputStream());
                NodeLevel loadLevel = this.getLevelForLoading(minimumLevel);
                candidate = JayceReaderFactory.get(this.inputJackLibrary, in).readType(loadLevel);
                if (this.id.isCachable()) {
                    cache.put(this.id, candidate);
                } else {
                    this.nnode = new SoftReference<DeclaredTypeNode>(candidate);
                }
            }
            catch (WrongPermissionException | IOException e) {
                throw new LibraryIOException(this.inputJackLibrary.getLocation(), e);
            }
            catch (JayceFormatException e) {
                logger.log(Level.SEVERE, "Library " + this.inputJackLibrary.getLocation().getDescription() + " is invalid", e);
                throw new LibraryFormatException(this.inputJackLibrary.getLocation());
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to close input stream on " + this.source.getLocation().getDescription(), e);
                }
            }
            this.tracer.getStatistic(NNODE_REREAD).add(this.nnodeReadCount > 0);
            ++this.nnodeReadCount;
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureStructure(@Nonnull JDefinedClassOrInterface loaded) {
        JayceClassOrInterfaceLoader jayceClassOrInterfaceLoader = this;
        synchronized (jayceClassOrInterfaceLoader) {
            if (!this.structureLoaded) {
                DeclaredTypeNode type;
                this.structureLoaded = true;
                try {
                    type = this.getNNode(NodeLevel.STRUCTURE);
                }
                catch (LibraryException e) {
                    throw new JackLoadingException(this.getLocation(), e);
                }
                try {
                    type.loadStructure(loaded, this);
                }
                catch (JLookupException e) {
                    throw new JackLoadingException(this.getLocation(), e);
                }
                ParentSetter parentSetter = new ParentSetter();
                parentSetter.accept(loaded);
                this.tracer.getStatistic(NNODE_STRUCTURE_LOAD).incValue();
            }
        }
    }

    @Override
    @Nonnull
    public InputLibrary getInputLibrary() {
        return this.inputJackLibrary;
    }

    private boolean checkName(@Nonnull String signature) {
        TypePackageAndMethodFormatter lookupFormatter = Jack.getLookupFormatter();
        String expectedSignature = lookupFormatter.getName(this.enclosingPackage, this.simpleName);
        if (!signature.equals(expectedSignature)) {
            throw new AssertionError((Object)("Wrong type in '" + this.source.getLocation().getDescription() + "', found '" + signature + "' while expecting '" + expectedSignature + "'"));
        }
        return true;
    }

    @Nonnull
    private NodeLevel getLevelForLoading(@Nonnull NodeLevel requiredData) {
        NodeLevel loadLevel = this.defaultLoadLevel;
        if (!loadLevel.keep(requiredData)) {
            loadLevel = requiredData;
        }
        return loadLevel;
    }

    static {
        Jack.getResourceRequestBus().register(new Object(){

            @Subscribe
            @SuppressFBWarnings(value={"UMAC_UNCALLABLE_METHOD_OF_ANONYMOUS_CLASS"})
            public void cleanMemory(@Nonnull CleanMemoryRequest event) {
                if (event.getImpacts().contains((Object)Impact.PERFORMANCE)) {
                    logger.log(Level.INFO, "Clean NNode cache on event request");
                    cache.invalidateAll();
                }
            }
        });
        logger = LoggerFactory.getLogger();
    }

    private static class NNodeId {
        @CheckForNull
        private final String digest;
        @Nonnull
        private final String fqName;
        @Nonnull
        private final String sessionId;

        public NNodeId(@Nonnull String sessionId, @CheckForNull String digest, @Nonnull String fqName) {
            this.digest = digest;
            this.fqName = fqName;
            this.sessionId = sessionId;
        }

        public boolean isCachable() {
            return this.digest != null;
        }

        @Nonnull
        public String getSessionId() {
            return this.sessionId;
        }

        public final boolean equals(Object obj) {
            if (obj instanceof NNodeId) {
                NNodeId id = (NNodeId)obj;
                if (this.digest == null || id.digest == null) {
                    return false;
                }
                return this.digest.equals(id.digest) && this.fqName.equals(id.fqName);
            }
            return false;
        }

        public final int hashCode() {
            return (this.digest != null ? this.digest.hashCode() : 0) ^ this.fqName.hashCode();
        }
    }
}

