/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce;

import com.android.jack.LibraryException;
import com.android.jack.ir.ast.JAnnotationType;
import com.android.jack.ir.ast.JField;
import com.android.jack.ir.ast.JSession;
import com.android.jack.jayce.DeclaredTypeNode;
import com.android.jack.jayce.FieldNode;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.library.HasInputLibrary;
import com.android.jack.library.InputLibrary;
import com.android.jack.library.LibraryFormatException;
import com.android.jack.library.LibraryIOException;
import com.android.jack.load.FieldLoader;
import com.android.jack.load.JackLoadingException;
import com.android.sched.marker.Marker;
import com.android.sched.util.location.Location;
import java.lang.ref.SoftReference;
import javax.annotation.Nonnull;

public class JayceFieldLoader
implements FieldLoader,
HasInputLibrary {
    @Nonnull
    private final JayceClassOrInterfaceLoader enclosingClassLoader;
    @Nonnull
    private SoftReference<FieldNode> nnode;
    @Nonnull
    private final String fieldId;
    private boolean isAnnotationsLoaded = false;

    public JayceFieldLoader(@Nonnull FieldNode nnode, @Nonnull String fieldId, @Nonnull JayceClassOrInterfaceLoader enclosingClassLoader) {
        this.enclosingClassLoader = enclosingClassLoader;
        this.nnode = new SoftReference<FieldNode>(nnode);
        this.fieldId = fieldId;
    }

    @Nonnull
    private FieldNode getNNode() throws LibraryFormatException, LibraryIOException {
        FieldNode node = this.nnode.get();
        if (node == null) {
            DeclaredTypeNode declaredTypeNode = this.enclosingClassLoader.getNNode(NodeLevel.STRUCTURE);
            node = declaredTypeNode.getFieldNode(this.fieldId);
            this.nnode = new SoftReference<FieldNode>(node);
        }
        return node;
    }

    @Override
    @Nonnull
    public Location getLocation(@Nonnull JField loaded) {
        return this.enclosingClassLoader.getLocation();
    }

    @Override
    public void ensureMarkers(@Nonnull JField loaded) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ensureAnnotations(@Nonnull JField loaded) {
        JayceFieldLoader jayceFieldLoader = this;
        synchronized (jayceFieldLoader) {
            if (this.isAnnotationsLoaded) {
                return;
            }
            try {
                FieldNode node = this.getNNode();
                node.loadAnnotations(loaded, this);
            }
            catch (LibraryException e) {
                throw new JackLoadingException(this.getLocation(loaded), e);
            }
            this.isAnnotationsLoaded = true;
        }
    }

    @Override
    @Nonnull
    public InputLibrary getInputLibrary() {
        return this.enclosingClassLoader.getInputLibrary();
    }

    @Override
    public void ensureMarker(@Nonnull JField loaded, @Nonnull Class<? extends Marker> cls) {
        this.ensureMarkers(loaded);
    }

    @Override
    public void ensureAnnotation(@Nonnull JField loaded, @Nonnull JAnnotationType annotation) {
        this.ensureAnnotations(loaded);
    }

    @Nonnull
    public JSession getSession() {
        return this.enclosingClassLoader.getSession();
    }
}

