/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JAlloc;
import com.android.jack.ir.ast.JClass;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NExpression;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NAlloc
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.ALLOC;
    @CheckForNull
    public String instanceType;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JAlloc alloc = (JAlloc)node;
        this.instanceType = ImportHelper.getSignatureName(alloc.getInstanceType());
        this.sourceInfo = loader.load(alloc.getSourceInfo());
    }

    @Override
    @Nonnull
    public JAlloc exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException {
        assert (this.sourceInfo != null);
        assert (this.instanceType != null);
        JClass jType = exportSession.getLookup().getClass(this.instanceType);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JAlloc jAlloc = new JAlloc(jSourceInfo, jType);
        return jAlloc;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.instanceType = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

