/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JConditionalExpression;
import com.android.jack.ir.ast.JExpression;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NExpression;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NConditionalExpression
extends NExpression {
    @Nonnull
    public static final Token TOKEN = Token.CONDITIONAL_EXPRESSION;
    @CheckForNull
    public NExpression ifTest;
    @CheckForNull
    public NExpression thenExpr;
    @CheckForNull
    public NExpression elseExpr;
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JConditionalExpression jConditionalExpression = (JConditionalExpression)node;
        this.ifTest = (NExpression)loader.load(jConditionalExpression.getIfTest());
        this.thenExpr = (NExpression)loader.load(jConditionalExpression.getThenExpr());
        this.elseExpr = (NExpression)loader.load(jConditionalExpression.getElseExpr());
        this.sourceInfo = loader.load(jConditionalExpression.getSourceInfo());
    }

    @Override
    @Nonnull
    public JConditionalExpression exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.ifTest != null);
        assert (this.thenExpr != null);
        assert (this.elseExpr != null);
        JExpression jIf = this.ifTest.exportAsJast(exportSession);
        JExpression jThen = this.thenExpr.exportAsJast(exportSession);
        JExpression jElse = this.elseExpr.exportAsJast(exportSession);
        SourceInfo jSourceInfo = this.sourceInfo.exportAsJast(exportSession);
        JConditionalExpression jConditionalExpression = new JConditionalExpression(jSourceInfo, jIf, jThen, jElse);
        return jConditionalExpression;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.ifTest = in.readNode(NExpression.class);
        this.thenExpr = in.readNode(NExpression.class);
        this.elseExpr = in.readNode(NExpression.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }
}

