/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JGoto;
import com.android.jack.ir.ast.JLabeledStatementUnresolved;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.linker.GotoLinker;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.jayce.v0002.nodes.NStatement;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NGoto
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.GOTO;
    @CheckForNull
    public String target;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JGoto jGoto = (JGoto)node;
        this.target = loader.getLabelSymbols().getId(jGoto.getTargetBlock());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), jGoto.getJCatchBlocks());
        this.sourceInfo = loader.load(jGoto.getSourceInfo());
    }

    @Override
    @Nonnull
    public JGoto exportAsJast(@Nonnull ExportSession exportSession) {
        assert (this.sourceInfo != null);
        assert (this.target != null);
        JGoto jGoto = new JGoto(this.sourceInfo.exportAsJast(exportSession), JLabeledStatementUnresolved.INSTANCE);
        exportSession.getLabelResolver().addLink(this.target, new GotoLinker(jGoto));
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jGoto));
        }
        return jGoto;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.target = in.readId();
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

