/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0002.nodes;

import com.android.jack.ir.ast.JAbstractMethodBody;
import com.android.jack.ir.ast.JAnnotation;
import com.android.jack.ir.ast.JDefinedClassOrInterface;
import com.android.jack.ir.ast.JMethod;
import com.android.jack.ir.ast.JMethodId;
import com.android.jack.ir.ast.JMethodIdWide;
import com.android.jack.ir.ast.JParameter;
import com.android.jack.ir.ast.JType;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.ir.ast.MethodKind;
import com.android.jack.ir.sourceinfo.SourceInfo;
import com.android.jack.jayce.JayceClassOrInterfaceLoader;
import com.android.jack.jayce.JayceMethodLoader;
import com.android.jack.jayce.MethodNode;
import com.android.jack.jayce.NodeLevel;
import com.android.jack.jayce.ParameterNode;
import com.android.jack.jayce.v0002.NNode;
import com.android.jack.jayce.v0002.io.ExportSession;
import com.android.jack.jayce.v0002.io.ImportHelper;
import com.android.jack.jayce.v0002.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0002.io.Token;
import com.android.jack.jayce.v0002.nodes.HasSourceInfo;
import com.android.jack.jayce.v0002.nodes.NAbstractMethodBody;
import com.android.jack.jayce.v0002.nodes.NAnnotation;
import com.android.jack.jayce.v0002.nodes.NMarker;
import com.android.jack.jayce.v0002.nodes.NParameter;
import com.android.jack.jayce.v0002.nodes.NSourceInfo;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class NMethod
extends NNode
implements HasSourceInfo,
MethodNode {
    @Nonnull
    public static final Token TOKEN = Token.METHOD;
    @CheckForNull
    protected String name;
    @CheckForNull
    protected String returnType;
    @Nonnull
    private List<NParameter> parameters = Collections.emptyList();
    @CheckForNull
    public MethodKind methodKind;
    public int modifier;
    @Nonnull
    public List<NAnnotation> annotations = Collections.emptyList();
    @CheckForNull
    public NAbstractMethodBody body;
    @Nonnull
    public List<NMarker> markers = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;
    @CheckForNull
    protected NodeLevel level;
    @CheckForNull
    protected String methodId;

    @Override
    @Nonnull
    public NodeLevel getLevel() {
        assert (this.level != null);
        return this.level;
    }

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object jElement) {
        JMethod jMethod = (JMethod)jElement;
        this.name = jMethod.getName();
        this.returnType = ImportHelper.getSignatureName(jMethod.getType());
        this.setParameters(loader.load(NParameter.class, jMethod.getParams()));
        this.methodKind = jMethod.getMethodIdWide().getKind();
        this.modifier = jMethod.getModifier();
        this.annotations = loader.load(NAnnotation.class, jMethod.getAnnotations());
        this.body = (NAbstractMethodBody)loader.load(jMethod.getBody());
        this.markers = loader.load(NMarker.class, jMethod.getAllMarkers());
        this.sourceInfo = loader.load(jMethod.getSourceInfo());
    }

    @Override
    @Nonnull
    public JMethod exportAsJast(@Nonnull ExportSession exportSession) {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public JMethod exportAsJast(@Nonnull ExportSession exportSession, @Nonnull JayceClassOrInterfaceLoader enclosingLoader) throws JTypeLookupException, JMethodLookupException {
        assert (this.name != null);
        assert (this.returnType != null);
        assert (this.methodKind != null);
        assert (this.sourceInfo != null);
        assert (this.methodId != null);
        SourceInfo info = this.sourceInfo.exportAsJast(exportSession);
        JDefinedClassOrInterface enclosingType = exportSession.getCurrentType();
        assert (enclosingType != null);
        JMethodIdWide id = new JMethodIdWide(this.name, this.methodKind);
        JType returnJType = exportSession.getLookup().getType(this.returnType);
        JayceMethodLoader methodLoader = new JayceMethodLoader(this, this.methodId, enclosingLoader);
        JMethod jMethod = new JMethod(info, new JMethodId(id, returnJType), enclosingType, this.modifier, methodLoader);
        exportSession.setCurrentMethod(jMethod);
        for (NParameter parameter : this.getParameters()) {
            JParameter jParam = parameter.exportAsJast(exportSession, methodLoader);
            jMethod.addParam(jParam);
            id.addParam(jParam.getType());
        }
        for (NMarker marker : this.markers) {
            jMethod.addMarker(marker.exportAsJast(exportSession));
        }
        NMethod.clearBodyResolvers(exportSession);
        return jMethod;
    }

    @Override
    @CheckForNull
    public JAbstractMethodBody loadBody(@Nonnull JMethod method, @Nonnull JayceMethodLoader loader) throws JTypeLookupException, JMethodLookupException {
        if (this.body != null) {
            ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.FULL);
            exportSession.setCurrentMethod(method);
            exportSession.setCurrentType(method.getEnclosingType());
            Iterator<JParameter> iter = method.getParams().iterator();
            for (NParameter parameter : this.getParameters()) {
                assert (parameter.id != null);
                exportSession.getParameterResolver().addTarget(parameter.id, iter.next());
            }
            JAbstractMethodBody jBody = this.body.exportAsJast(exportSession);
            method.setBody(jBody);
            NMethod.clearBodyResolvers(exportSession);
            return jBody;
        }
        return null;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.level = in.getNodeLevel();
        this.name = in.readId();
        this.returnType = in.readId();
        this.setParameters(in.readNodes(NParameter.class));
        this.methodKind = in.readMethodKindEnum();
        this.modifier = in.readInt();
        this.annotations = in.readNodes(NAnnotation.class);
        this.body = in.readNode(NAbstractMethodBody.class);
        this.markers = in.readNodes(NMarker.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setId(@Nonnull String id) {
        this.methodId = id;
    }

    protected static void clearBodyResolvers(ExportSession exportSession) {
        exportSession.getLocalResolver().clear();
        exportSession.getCaseResolver().clear();
        exportSession.getCatchBlockResolver().clear();
        exportSession.getLabelResolver().clear();
        exportSession.getParameterResolver().clear();
    }

    @Override
    public void loadAnnotations(@Nonnull JMethod loading, @Nonnull JayceMethodLoader loader) {
        if (!this.annotations.isEmpty()) {
            ExportSession exportSession = new ExportSession(loader.getSession(), NodeLevel.STRUCTURE);
            for (NAnnotation annotation : this.annotations) {
                JAnnotation annote = annotation.exportAsJast(exportSession);
                loading.addAnnotation(annote);
                annote.updateParents(loading);
            }
        }
    }

    @Nonnull
    public List<NParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nonnull List<NParameter> parameters) {
        this.parameters = parameters;
        int parameterIndex = 0;
        for (NParameter nParameter : parameters) {
            nParameter.setIndex(parameterIndex);
            ++parameterIndex;
        }
    }

    @Override
    @Nonnull
    public ParameterNode getParameterNode(@Nonnegative int parameterNodeIndex) {
        return this.getParameters().get(parameterNodeIndex);
    }

    @Nonnull
    public String getName() {
        assert (this.name != null);
        return this.name;
    }

    @Nonnull
    public String getReturnType() {
        assert (this.returnType != null);
        return this.returnType;
    }
}

