/*
 * Decompiled with CFR 0.152.
 */
package com.android.jack.jayce.v0003.nodes;

import com.android.jack.ir.ast.JCaseStatement;
import com.android.jack.ir.ast.JLiteral;
import com.android.jack.ir.ast.JTypeLookupException;
import com.android.jack.jayce.linker.CatchBlockLinker;
import com.android.jack.jayce.v0003.io.ExportSession;
import com.android.jack.jayce.v0003.io.ImportHelper;
import com.android.jack.jayce.v0003.io.JayceInternalReaderImpl;
import com.android.jack.jayce.v0003.io.Token;
import com.android.jack.jayce.v0003.nodes.NLiteral;
import com.android.jack.jayce.v0003.nodes.NSourceInfo;
import com.android.jack.jayce.v0003.nodes.NStatement;
import com.android.jack.lookup.JMethodLookupException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NCaseStatement
extends NStatement {
    @Nonnull
    public static final Token TOKEN = Token.CASE_STATEMENT;
    @CheckForNull
    public String id;
    @CheckForNull
    public NLiteral expr;
    @Nonnull
    public List<String> catchBlockIds = Collections.emptyList();
    @CheckForNull
    public NSourceInfo sourceInfo;

    @Override
    public void importFromJast(@Nonnull ImportHelper loader, @Nonnull Object node) {
        JCaseStatement caseStatement = (JCaseStatement)node;
        this.id = loader.getCaseSymbols().getId(caseStatement);
        this.expr = (NLiteral)loader.load(caseStatement.getExpr());
        this.catchBlockIds = loader.getIds(loader.getCatchBlockSymbols(), caseStatement.getJCatchBlocks());
        this.sourceInfo = loader.load(caseStatement.getSourceInfo());
    }

    @Override
    @Nonnull
    public JCaseStatement exportAsJast(@Nonnull ExportSession exportSession) throws JTypeLookupException, JMethodLookupException {
        assert (this.sourceInfo != null);
        assert (this.id != null);
        JLiteral jExpr = this.expr != null ? this.expr.exportAsJast(exportSession) : null;
        JCaseStatement jCase = new JCaseStatement(this.sourceInfo.exportAsJast(exportSession), jExpr);
        exportSession.getCaseResolver().addTarget(this.id, jCase);
        for (String catchId : this.catchBlockIds) {
            exportSession.getCatchBlockResolver().addLink(catchId, new CatchBlockLinker(jCase));
        }
        return jCase;
    }

    @Override
    public void readContent(@Nonnull JayceInternalReaderImpl in) throws IOException {
        this.id = in.readId();
        this.expr = in.readNode(NLiteral.class);
    }

    @Override
    @Nonnull
    public Token getToken() {
        return TOKEN;
    }

    @Override
    @Nonnull
    public NSourceInfo getSourceInfos() {
        assert (this.sourceInfo != null);
        return this.sourceInfo;
    }

    @Override
    public void setSourceInfos(@Nonnull NSourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    @Override
    @Nonnull
    public List<String> getCatchBlockIds() {
        return this.catchBlockIds;
    }

    @Override
    public void setCatchBlockIds(@Nonnull List<String> catchBlockIds) {
        this.catchBlockIds = catchBlockIds;
    }
}

